
import { CustomerView } from '../../customers/CustomerView.js';
import { ArticleSearchPopup } from '../article/ArticleSearchPopup.js';

import { ContractRentalLineForm }  from './item/ContractRentalLineForm.js';
import { ContractArticleLineForm } from './item/ContractArticleLineForm.js';
import { ContractPriceLineForm }   from './item/ContractPriceLineForm.js';


export class RentalContractEditWidget {
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.goBack_Click" class="fa fa-chevron-circle-left"></a>
				
				<a href="javascript:void(0);" [onclick]="widget.delete_Click" class="fa fa-trash"></a>
			</div>
			
			<h1>{{ _('Contracts for') }} <span class="customer-name">...</span></h1>
			
		</div>
		
		<div class="rental-contract-edit-widget">
			<div id="customer-overview"></div>
			
			<div id="other-contracts" class="contracts-list"></div>
			
			<hr/>
			
			<div id="current-contract" class="contract-view"></div>
		</div>
	`;
	
	
	tplContractList = `
		<div class="contracts-header">
			<div class="col-contract">#</div>
			<div class="col-description">{{_('Description')}}</div>
			<div class="col-start">{{_('Start')}}</div>
			<div class="col-end">{{_('End')}}</div>
			<div class="col-renewal">{{_('Renewal')}}</div>
			<div class="col-price">
				{{_('Price')}}
				{{salesSettings.inputPrice == 'excl_vat' ? 'excl.' : ''}}
				{{salesSettings.inputPrice == 'incl_vat' ? 'incl.' : ''}}
			</div>
		</div>
		<div ez-for="lines" ez-item="l" style="overflow: auto;">
			<div class="contract-line {{ l.rentalContractId == contract.rentalContractId ? 'selected' : '' }}"
					[onclick]="widget.contract_Click" [line]="l">
				<div class="col-contract">{{ l.rentalContractId }}</div>
				<div class="col-description">
					{{ l.contractDescription }}
					-
					{{ l.lineDescription }}
				</div>
				<div class="col-start">{{ format_date(l.startTime, {dmy: true}) }}</div>
				<div class="col-end">{{ format_date(l.endTime, {dmy: true})  }}</div>
				<div class="col-renewal">
					<span ez-if="l.renewalPeriod > 0">
						{{ l.renewalPeriod }}
						{{ l.renewalType }}
					</span>
				</div>
				<div class="col-price">
					<span ez-if="salesSettings.inputPrice == 'excl_vat'">
						{{ format_price(l.priceExclVat, true) }}
					</span>
					<span ez-if="salesSettings.inputPrice == 'incl_vat'">
						{{ format_price(l.priceInclVat, true) }}
					</span>
				</div>
			</div>
		</div>
	`;
	
	


	tplContract = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.saveContract" class="fa fa-save"></a>
			</div>
			
			
			<h2>Contract #{{contract.rentalContractId}}</h2>
		</div>
		
		<div class="contract-details">
			<ez-checkbox label="Active"
						name="active"
						[checked]="contract.active"></ez-checkbox>
			
			<ez-text label="Description" 
						name="description" 
						[value]="contract.description"></ez-text>
		</div>
					
		<div class="contract-lines">
			<div class="contract-lines-header">
				<div class="col-sort">&nbsp;</div>
				<div class="col-description">{{_('Description')}}</div>
				<div class="col-period">{{_('Period')}}</div>
				<div class="col-renewal">{{_('Renewal')}}</div>
				<div class="col-vat">{{_('Vat')}}</div>
				<div class="col-price">
					{{_('Price')}}
					{{salesSettings.inputPrice == 'excl_vat' ? 'excl.' : ''}}
					{{salesSettings.inputPrice == 'incl_vat' ? 'incl.' : ''}}
				</div>
			</div>
			<div class="contract-lines-content" ez-for="lines" ez-item="l">
				<div class="contract-line" [onclick]="widget.editLine_Click" [line]="l">
					<div class="col-sort"><span class="fa fa-bars sort-handler"></span></div>
					<div class="col-description">{{l.articleDescription}}</div>
					<div class="col-period">
						<span ez-if="l.rentalType == 'day'">
							{{format_date(l.startTime, {dmy: true})}}
							
							{{ l.startTime && l.endTime ? ' t/m ' : '' }}
							
							{{format_date(l.endTime, {dmy: true})}}
						</span>
						<span ez-if="l.rentalType == 'hour'">
							{{format_datetime(l.startTime, {dmy: true,skipSeconds: true})}}
							
							<span ez-if="format_date(l.startTime) == format_date(l.endTime)">
								t/m
								{{ format_time(l.endTime) }}
							</span>
							<span ez-if="format_date(l.startTime) != format_date(l.endTime)">
								t/m 
								{{format_datetime(l.endTime, {dmy: true,skipSeconds: true})}}
							</span>
							
						</span>
					</div>
					<div class="col-renewal">
						<span ez-if="l.renewalPeriod > 0">
							{{l.renewalPeriod ?? ''}}
							{{l.renewalType ?? ''}}
						</span>
					</div>
					<div class="col-vat">
						{{l.vatDescription}}
					</div>
					<div class="col-price">
						<span ez-if="salesSettings.inputPrice == 'excl_vat'">{{ format_price(l.priceExclVat, true) }}</span>
						<span ez-if="salesSettings.inputPrice == 'incl_vat'">{{ format_price(l.priceInclVat, true) }}</span>
					</div>
					<div class="col-actions">
						<a href="javascript:void(0);" [onclick]="widget.removeLine_Click" class="fa fa-remove"></a>
					</div>
				</div>
			</div>
		<div>
		
		<div class="action-box" style="margin-top: 25px;">
			<span><a href="javascript:void(0);" [onclick]="widget.addArticle_Click">{{_('Add article')}}</a></span>
			<span><a href="javascript:void(0);" [onclick]="widget.addPriceLine_Click">{{_('Add price line')}}</a></span>
		</div>
		
		
		<div id="container-line-edit"></div>
	`;
	
	
	
	container = null;
	ezTpl = null;
	
	contract = null;
	
	salesSettings = null;
	
	lines = null;
	
	
	init(e) {
		this.container = e;
		this.render();
		
		
		let id = getUrlParam('id');
		
		this.loadContract( id );
	}
	
	goBack_Click() {
		gotoRoute( '/sales/rental/' );
	}
	
	delete_Click() {
		
		showConfirmation(_('Delete'), _('Are you sure to delete this contract?'), async () => {
			
			showLoadingForm('.rental-contract-edit-widget');
			
			await postJson('/service/sales/rental/rental.do', {
				a: 'deleteContract',
				rentalContractId: this.contract.rentalContractId
			});
			
			gotoRoute( '/sales/rental/' );
		});
		
	}
	
	
	loadContract(id) {
		postJson( '/service/sales/rental/rental.do', {
			a: 'readContract',
			rentalContractId: id
		}).then( async (r) => {
			
			let json = await r.json();
			
			$('.customer-name').text( json.customer != null ? json.customer.customerName : '-' );
			this.contract = json.contract;
			this.lines = json.lines;
			
			console.log('json stuff', json);
			
			this.salesSettings = json.salesSettings;
			
			this.renderCustomer( json.customer );
			
			this.renderContract( json.contract );
			
			this.renderContracts( json.contract, json.lines );
			
		}).catch( (err) => {
			console.error('Error', err);
		});
	}
	
	
	
	renderCustomer( customer ) {
		let cw = new CustomerView( customer );
		cw.render( 'customer-overview' );
	}
	
	renderContract( contract ) {
		let ezTpl = new EzTemplate('current-contract');
		ezTpl.setObject('widget', this);
		ezTpl.setVar('contract', contract);
		ezTpl.setVar('lines', this.lines);
		ezTpl.setVar('salesSettings', this.salesSettings);
		ezTpl.loadHtml( this.tplContract );
		
		ezTpl.render();
		
		$('#current-contract .contract-lines-content').sortable({
			handle: '.sort-handler'
		})
	}
	
	renderContracts( contract, lines ) {
		let ezTpl = new EzTemplate('other-contracts');
		ezTpl.setObject('widget', this);
		ezTpl.setVar('contract', contract);
		ezTpl.setVar('lines', lines);
		ezTpl.setVar('salesSettings', this.salesSettings);
		ezTpl.loadHtml( this.tplContractList );

		ezTpl.render();
	}
	
	contract_Click( evt, tr ) {
		let line = tr.line;
		
		gotoRoute( '/sales/rental/edit/?id=' + line.rentalContractId );
	}
	
	
	editLine_Click( evt, tr ) {
		if ( $(evt.target).hasClass('col-actions') || $(evt.target).closest('.col-actions').length > 0 )
			return;
		if ( $(evt.target).hasClass('col-sort') || $(evt.target).closest('.col-sort').length > 0 )
			return;
		
		
		let line = tr.line;
		this.editLine( line );
	}
	editLine(line) {
		if (line.lineType == 'rental') {
			let f = new ContractRentalLineForm('#container-line-edit', line);
			
			f.setSaveCallback((l) => {
				// line was passed-on as a reference. Just re-render..
				this.renderContract( this.contract );
			});
			
			f.render();
		}
		else if (line.lineType == 'article') {
			let f = new ContractArticleLineForm('#container-line-edit', line);
			
			f.setSaveCallback((l) => {
				// line was passed-on as a reference. Just re-render..
				this.renderContract( this.contract );
			});
			
			f.render();
		}
		else if (line.lineType == 'priceline') {
			let f = new ContractPriceLineForm('#container-line-edit', line);
			
			f.setSaveCallback((l) => {
				
				if (l.isNew) {
					this.lines.push( l );
				}
				
				// line was passed-on as a reference. Just re-render..
				this.renderContract( this.contract );
			});
			
			f.render();
		}
	}
	
	
	removeLine_Click( evt, anch ) {
		let line = $(anch).closest('.contract-line').get(0).line;
		
		showConfirmation(_('Are you sure'), _('Are you sure to remove') + ': ' + line.description,() => {
			this.removeLine( line );
		});
	}
	
	removeLine( line ) {
		
		// remove from html table
		$('#current-contract .contract-line').each(function(index,node) {
			if ( node.line == line )
				$(node).remove();
		});
		
		// remove from list
		let newLines = [];
		for(let i=0; i < this.lines.length; i++) {
			if (this.lines[i] == line) continue;
			
			newLines.push( this.lines[i] );
		}
		
		this.lines = newLines;
		
		
		// close edit-box
		$('#container-line-edit').empty();
	}
	
	
	
	getRefLineNewRental() {
		for(let i=0; i < this.lines.length; i++) {
			let l = this.lines[i];
			
			if ( l.lineType == 'rental' ) {
				return l;
			}
		}
		
		return null;
	}
	
	addArticle_Click() {
		let p = new ArticleSearchPopup();

		p.setSelectArticle((article) => {
			
			console.log( article );
			let line = {};
			line.number             = 1;
			line.lineType           = article.rentable ? 'rental' : 'article';
			line.articleId          = article.articleId;
			line.articleCode        = article.articleCode;
			line.description        = article.shortDescription;
			line.articleDescription = article.shortDescription;
			line.priceExclVat       = article.priceExclVat;
			line.priceInclVat       = article.priceInclVat;
			line.vatId              = article.vatId;
			
			if (article.rentable) {
				let ref = this.getRefLineNewRental();
				
//				console.log('ref', ref);
				
				// recurring?
				if (ref && (ref.renewalType == 'week' || ref.renewalType == 'month' || ref.renewalType == 'year')) {
					line.renewalPeriod = ref.renewalPeriod;
					line.renewalType   = ref.renewalType;

					let refstart = format_date( ref.startTime, {ymdnumeric: true});
					let now = format_date( new Date(), {ymdnumeric: true});
					
					// start in future?
					if (refstart > now) {
						line.startTime     = format_date( new Date() );
						line.endTime       = ref.endTime;
					}
					// start in past?
					else {
						line.startTime     = format_date( new Date() );
						line.endTime       = ref.endTime;
					}
					
				}
				else if (ref) {
					line.renewalPeriod = ref.renewalPeriod;
					line.renewalType   = ref.renewalType;
					
					line.startTime     = ref.startTime;
					line.endTime       = ref.endTime;
				}
				else {
					line.renewalPeriod = '';
					line.renwalType = 'none';
					line.startTime  = format_date( new Date() );
					line.endTime    = end_of_month();
				}
				
			}
			
			
			this.contract.lines.push( line );
				
			this.renderContract( this.contract );
			
			this.editLine( line );
		});

		p.show();
		
	}
	
	addPriceLine_Click() {
		let l = {};
		l.isNew = true;
		l.lineType = 'priceline';
		l.number = 1;
		
		this.editLine(l);
	}
	
	
	saveContract() {
		
		this.contract.active = $('#current-contract').find('input[name=active]').prop('checked') ? true : false;
		this.contract.description = $('#current-contract').find('input[name=description]').val();
		
		// sort
		let lines = [];
		$('#current-contract .contract-lines-content .contract-line').each((index, node) => {
			lines.push( node.line );
		});
		this.contract.lines = lines;
		
		// show loading
		showLoadingForm('#current-contract');
		
		postJson('/service/sales/rental/rental.do', {
			a: 'saveContract',
			contract: this.contract
		}).then(async (e) => {
			let json = await e.json();
			
//			console.log('RentalController.saveAction', json);

			reportUserMessage( _('Changes saved') );			

			gotoRoute( '/sales/rental/edit/?id=' + json.rentalContractId );
		}).catch((err) => {
			console.error('Error', err);
			reportUserError( err );
		});
		
	}
	
	
	render() {
		
		this.ezTpl = new EzTemplate( this.container );
		
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		
	}
	
}

