



export class OrderListWidget {
	
	container = null;
	vats = null;
	
	salesSettings = null;
	ezTpl = null;
	
	pageNo = 0;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/sales/order/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Orders</h1>
		</div>
		
		<div ez-if="orders == null">
			Loading...
		</div>
		<div ez-if="orders != null">
			<table class="table">
				<thead>
					<tr>
						<th>Order Nr</th>
						<th>Klant</th>
						<th>Omschrijving</th>
						<th>Bedrag {{amountNote}}</th>
						<th>Status</th>
						<th>Datum</th>
					</tr>
				</thead>
				<tbody  ez-for="orders" ez-item="o" class="tbody-orders">
					<tr [onclick]="widget.editOrder" class="pointer" order-id="{{o.orderId}}">
						<td>{{o.orderNumber}}</td>
						<td>{{o.customerName}}</td>
						<td>{{o.subject}}</td>
						<td>
						
							{{ priceExcl ? o.totalCalculatedPrice : o.totalCalculatedPriceInclVat }}
						</td>
						<td>{{_('orderStatus.'+o.orderStatus)}}</td>
						<td>{{ format_date(o.orderDate, {dmy:true})}}</td>
					</tr>
				</tbody>
					
				<tbody ez-if="orders.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	
	
	editOrder(evt, tr) {
		let oid = tr.getAttribute('order-id');
		
		gotoRoute( '/sales/order/edit/?id='+oid );
	}


	selectPage(pageNo) {
		this.pageNo = pageNo;
		this.searchOrders();
	}

	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('orders', this.orders);
		
		if (this.salesSettings && this.salesSettings.inputPrice == 'excl_vat') {
			this.ezTpl.setVar('amountNote', '(excl)');
			this.ezTpl.setVar('priceExcl', true);
			this.ezTpl.setVar('priceIncl', false);
		}
		if (this.salesSettings && this.salesSettings.inputPrice == 'incl_vat') {
			this.ezTpl.setVar('amountNote', '(incl)');
			this.ezTpl.setVar('priceExcl', false);
			this.ezTpl.setVar('priceIncl', true);
		}
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
	}
	
	
	
	searchOrders() {
		postUrl( '/service/sales/order.do', {
			a: 'search',
			pageNo: this.pageNo
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.salesSettings = json.salesSettings;
			this.orders = json.orders;
			this.render();
			
		}.bind(this) );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		
		this.searchOrders();
	}

}

