



export class SalesSettingsWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.save" class="fa fa-save"></a>
			</div>
			
			<h1>Sales Instellingen</h1>
		</div>
		
		<span ez-if="settings == null">Loading...</span>
		
		<div ez-if="settings != null">
			<form id="frmSalesSettings">
			
				<ez-radio name="inputPrice" [value]="settings.inputPrice" label="Invoer prijzen">
					<option value="excl_vat">Excl. btw</option>
					<option value="incl_vat">Incl. btw</option>
				</ez-radio>
			
				
				
				<fieldset style="margin-top: 25px;">
					<legend>Verhuur</legend>
					
					<ez-checkbox name="weekPrices" [checked]="settings.weekPrices" label="Weekprijzen"></ez-checkbox>

					<div class="month-prices">
						<ez-checkbox name="monthPrices" [onchange]="widget.updateState" [checked]="settings.monthPrices" label="Maandprijzen"></ez-checkbox>
						
						&nbsp;&nbsp;&nbsp;
						<span id="monthPricesSettings">
							<ez-radio name="startMonthInvoice" [value]="settings.startMonthInvoice" label="Start facturatie">
								<option value="begin_month">Begin maand</option>
								<option value="start_contract">Start dag</option>
							</ez-radio>
						</span>
					</div>
					
					<ez-checkbox name="slotplanPrices" [checked]="settings.slotplanPrices" label="Slotplan prijzen"></ez-checkbox>
					
					<div style="margin: 15px 0 5px; font-weight: bold;">Tijden dag verhuur</div>
					<ez-time label="Start uur" 
								name="rentalDailyStartTime"
								[value]="settings.rentalDailyStartTime"></ez-time>
					<ez-time label="Eind uur" 
								name="rentalDailyEndTime"
								[value]="settings.rentalDailyEndTime"></ez-time>
					
				</fieldset>
								
				
			</form>
		</div>
		
	`;
	
	container = null;
	ezTpl = null;
	settings = null;
	
	init(e) {
		this.container = e;
		this.render();
		
		this.loadSettings();
	}
	
	loadSettings() {
		postUrl( '/service/sales/settings.do' )
		.then( async function(e) {
			let json = await e.json();
			this.settings = json.settings;
			this.render();
		}.bind(this) );
	}
	
	updateState() {
		if ( $('input[name=monthPrices]').prop('checked') ) {
			$('#monthPricesSettings').show();
		}
		else {
			$('#monthPricesSettings').hide();
		}
	}
	
	
	save() {
		let frm = $('#frmSalesSettings');
		
		let d = {};
		d.a = 'save';
		d.inputPrice        = frm.find('input[name=inputPrice]:checked').val();
		d.weekPrices        = frm.find('input[name=weekPrices]').prop('checked') ? 1 : 0;
		d.monthPrices       = frm.find('input[name=monthPrices]').prop('checked') ? 1 : 0;
		d.startMonthInvoice = frm.find('input[name=startMonthInvoice]:checked').val();
		d.slotplanPrices    = frm.find('input[name=slotplanPrices]').prop('checked') ? 1 : 0;
		d.rentalDailyStartTime = frm.find('input[name=rentalDailyStartTime]').val();
		d.rentalDailyEndTime   = frm.find('input[name=rentalDailyEndTime]').val();
		
		postUrl( '/service/sales/settings.do', d )
		.then( async function(e) {
			let json = await e.json();
			reportUserMessage('Wijzigingen opgeslagen');
			
			gotoRoute( '/masterdata/sales/settings/' );
		}.bind(this) );
	}
		
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('settings', this.settings);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		this.updateState();
		
	}
	
}

