


export class GroupListWidget {
	
	container = null;
	groups = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/groups/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Groepen overzicht</h1>
		</div>
		
		<div ez-if="groups == null">
			Loading...
		</div>
		<div ez-if="groups != null">
			<table class="table">
				<thead>
					<tr>
						<th></th>
						<th>{{_('Group name')}}</th>
						<th>{{_('Default selected')}}</th>
						<th></th>
					</tr>
				</thead>
				<tbody  ez-for="groups" ez-item="g" class="tbody-groups">
					<tr [onclick]="widget.editGroup" class="pointer">
						<td class="sort-cell"><i class="fa fa-bars sort-handle"></i></td>
						<td group-id="{{g.userGroupId}}">
							{{g.groupName}}
						</td>
						<td>
							{{g.defaultSelected ? _('Yes') : _('No')}}
						</td>
						<td class="actions">
							<a href="{{appUrl('/masterdata/groups/edit/?id='+g.groupId)}}" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="groups.length == 0">
					<tr>
						<td colspan="100%" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	editGroup(evt, tr) {
		let target = evt.target;
		if ($(target).hasClass('sort-cell') || $(target).closest('.sort-cell').length > 0)
			return;
		
		let gid = tr.querySelector('td[group-id]').getAttribute('group-id');
		
		gotoRoute( '/masterdata/groups/edit/?id='+gid );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('groups', this.groups);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		$(this.container).find('.tbody-groups').sortable({
			handle: '.sort-handle',
			update: function() {
				this.saveSort();
			}.bind(this)
		});
	}
	
	saveSort() {
		let ids = [];
		$('.tbody-groups tr').each(function(index, node) {
			let id = $(node).find('td[group-id]').attr('group-id');
			ids.push(id);
		});
		
		postUrl( '/service/groups.do', {
			a: 'updateSort',
			ids: ids.join(',')
		}).then(() => {
			showToastMessage( 'Volgorde opgeslagen' );
		});
	}
	
	
	loadGroups() {
		postUrl( '/service/groups.do').then( async function(e) {
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				showErrorWidget( json );
			}
			
			this.groups = json.objects;
			this.render();
		}.bind(this));
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadGroups();
	}

}

