

export class WebSessionsWidget {
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a onclick="gotoRoute('/masterdata/');" class="fa fa-chevron-circle-left"></a>
			</div>
			
			<h1>{{_('User sessions')}}</h1>
		</div>
		
		<div>
			<input class="top-q" type="text" name="q" autocomplete="off" placeholder="{{_('Username, ...')}}" />
			
			<div ez-subtemplate="websessionslist">
				<div ez-if="websessions == null">
					Loading...
				</div>
				<div ez-if="websessions != null">
				
					<table class="table">
						<thead>
							<tr>
								<th style="width: 80px;">Id</th>
								<th>{{_('Username')}}</th>
								<th style="width: 100px;">{{_('Expiry')}}</th>
								<th style="width: 140px;">{{_('Timestamp')}}</th>
								<th style="width: 200px;"></th>
							</tr>
						</thead>
						<tbody ez-for="websessions" ez-item="ws">
							<tr data-web-session-id="{{ws.webSessionId}}" class="{{ws.webSessionId == currentWebSessionId ? 'row-highlighted' : ''}}">
								<td>
									{{ws.webSessionId}}
								</td>
								<td>
									{{ws.username}}
								</td>
								<td>
									{{ws.expiry}}
								</td>
								<td>
									{{format_datetime(new Date(ws.timestamp*1000))}}
								</td>
								<td class="actions">
									<button [onclick]="widget.destroySession_Click">Remove</button>
								</td>
							</tr>
						</tbody>
							<tr ez-if="websessions.length == 0">
								<td colspan="4" class="no-results">{{_('No results found')}}</td>
							</tr>
					</table>
					
					<ez-pager></ez-pager>
					
				</div>
			</div>
		</div>
	`;
	
	container = null;
	loadSessionsAbortController = null;
	currentWebSessionId = null;

	
	init(e) {
		this.container = e;
		
		this.q = getUrlParam('q') ?? '';
		this.pageNo = getUrlParam('pageNo') ?? 0;
		
		this.render();
		
		$('.top-q').focus();
		
		$(e).find('.top-q').val( this.q );
		
		// change = enter hit
		$(e).find('.top-q').on('change', function(evt) {
			if (this.keyupTimeout != null) {
				clearTimeout( this.keyupTimeout );
			}
			
			let q = $(evt.currentTarget).val();
			q = $.trim(q);
			
			if (this.selectionMode) {
				this.q = q;
				this.pageNo = 0;
				this.loadCustomers();
			}
			else {
				gotoRoute( '/masterdata/websessions/' + '?q=' + encodeURIComponent(q) );
			}
		}.bind(this));
	}
	

	async loadSessions( opts ) {
		opts = opts ?? {};
		
		if (this.loadSessionsAbortController != null) {
			this.loadSessionsAbortController.abort();
		}
		
		this.loadSessionsAbortController = new AbortController();
		let data = {};
		data.a = 'search';
		data.q = this.q;
		data.pageNo = this.pageNo;
		
		if ($.trim(this.q) == '' && this.selectedCustomerId) {
			data.selectedCustomerId = this.selectedCustomerId;
		}
		
		let searchResponse = await postUrl('/service/websessions.do'
			, data
			, {
				signal: this.loadSessionsAbortController.signal
			}
		);
		
		let resp = await searchResponse.json();
		
		if (resp.error) {
			showErrorWidget( resp );
		}
		
		
		this.currentWebSessionId = resp.currentWebSessionId;
		
		let eztpl = $('[ez-subtemplate=websessionslist]').get(0).eztemplate;
		
//		eztpl.setObject('widget', this);
		eztpl.setVar('websessions', resp.websessions);
		eztpl.setVar('currentWebSessionId', resp.currentWebSessionId);
		eztpl.setVar('response', resp);
		
		eztpl.render();
//		.catch( showErrorWidget )
	}
	
	selectPage( pageNo ) {
		if (this.selectionMode) {
			this.pageNo = pageNo;
			this.loadSessions();
		}
		else {
			gotoRoute( '/masterdata/websessions/' + '?pageNo=' + pageNo + '&q=' + encodeURIComponent(this.q) );
		}
	}

	
	async destroySession_Click(evt, obj) {
		let webSessionId = $(obj).closest('tr').data('web-session-id');
		
		if (webSessionId == this.currentWebSessionId) {
			showConfirmation( _('Destroy session'), _('Are you sure to destroy your current session?'), () => {
				this.destroySession( webSessionId );
			});
		}
		else {
			this.destroySession( webSessionId );
		}
	}
	
	
	async destroySession( webSessionId ) {
		let r = await postJson('/service/websessions.do', {
			a: 'delete',
			webSessionId: webSessionId
		});
		
		let pageNo = this.pageNo ?? '';
		
		reportUserMessage( _('Session removed, user is logged out') );
		gotoRoute( '/masterdata/websessions/' + '?pageNo=' + pageNo + '&q=' + encodeURIComponent(this.q) );
	}
	
	
	render() {
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('websessions', null);
		eztpl.setVar('currentWebSessionId', this.currentWebSessionId);
		
		eztpl.render();
		
		this.loadSessions();
	}
	
	
}

