


export class FileUploadPickPopup {
	
	tpl = `
		<div class="file-upload-pick-popup">
			<div class="page-header">
				<div class="toolbox">
					<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
					<a href="javascript:void(0);" [onclick]="widget.saveFile" class="fa fa-upload"></a>
				</div>
				<h1>Bestand uploaden</h1>
			</div>
	
			<form id="frmFusp">
				<ez-file name="file" label="Bestand"></ez-file>
				
				<ez-text name="ref_description" label="Reference" [value]="file.refDescription"></ez-text>
				<ez-textarea name="note" label="Notitie" [value]="file.note"></ez-textarea>
			</form>
			
			<hr />
			
			<input type="text" class="top-q" name="qfile" value="" class="" placeholder="Zoek bestand..." />
			
			<div ez-subtemplate="filesearch">
				<table class="table">
					<thead>
						<tr>
							<th>Bestandsnaam</th>
							<th>Ref.</th>
							<th>Grootte</th>
							<th style="width: 200px;">Aangemaakt op </th>
						</tr>
					</thead>
					<tbody ez-for="files" ez-item="f">
						<tr file-id="{{f.dbFileId}}" [file]="f" [onclick]="widget.fileClick" class="pointer">
							<td>{{f.originalFilename}}</td>
							<td>{{f.refDescription}}</td>
							<td style="width: 100px;">
								{{bytes2human(f.size)}}
							</td>
							<td style="width: 200px;">
								{{ format_datetime(new Date(f.created), {dmy: true}) }}
							</td>

						</tr>
					</tbody>
					
					<tbody ez-if="files == null || files.length == 0">
						<tr>
							<td colspan="100%" class="no-results">
								{{ files == null ? 'Loading...' : 'Geen resultaten gevonden' }}
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	`;
	
	isNew = true;
	
	files = null;
	
	
	callback_pick = null;
	callback_close = null;
	
	container = null;
	
	searchKeyupTimeout = null;
	
	setFiles(files) {
		this.files = files;
	}
	
	
	setCallbackPick( callback ) {
		this.callback_pick = callback;
	}
	
	setCallbackClose( callback ) {
		this.callback_close = callback;
		
		if (this.container) {
//			this.container.get(0).callback_close = this.callback_close;
		}
	}
	
	
	
	fileClick( evt, obj ) {
		let tr = $(evt.target).closest('tr');
		let ch = tr.find('.file-checked');
		
		if ($(evt.target).hasClass('file-checked') == false) {
			ch.prop('checked', !ch.prop('checked'));
		}
		
		let fid = ch.val();
		let db_file = obj.file;
		
		// link file to contract
		if (this.callback_pick) {
			this.callback_pick( fid, db_file );
			this.close();
		}
	}
	
	
	saveFile() {
		if (this.validate() > 0)
			return;
		
		let fd = new FormData();
		fd.append("file", $('#frmFusp input[name=file]').get(0).files[0]);
		fd.append('a', 'save');
		fd.append('ref_description', $('#frmFusp input[name=ref_description]').val());
		fd.append('note', $('#frmFusp textarea[name=note]').val());
		
		
		
		fetch(appUrl('/service/files.do'), {
			method: 'POST',
			body: fd
		}).then(async function(e) {
			let json = await e.json();
			
			console.log(json);
			
			if (this.callback_pick) {
				this.callback_pick( json.file.dbFileId, json.file );
			}
			
			this.close();
		}.bind(this));
		
		
//		close_popup();
	}
	
	
	searchFiles() {
		
		let selectedFileIds = [];
		for(let i in this.selectedFiles) {
			let dfid = parseInt( this.selectedFiles[i].dbFileId );
			if (isNaN(dfid) == false)
				selectedFileIds.push( dfid );
		}
		
		postUrl( '/service/files.do', {
				a: 'search',
				q: $('.file-upload-pick-popup input[name=qfile]').val(),
				selectedFileIds: selectedFileIds.join(',')
			}).then( async function(e) {
				let json = await e.json();
				this.setFiles( json.files );
				
				let eztpl = $('.file-upload-pick-popup [ez-subtemplate=filesearch]').get(0).eztemplate;
				console.log( eztpl );
				eztpl.setVar('files', this.files);
				eztpl.render();
			}.bind(this) );
	}
	
	validate() {
		$(this.container).find('span.error').text( '' );
		
		
		let errorCount = 0;
		
		let f = $('#frmFusp input[name=file]');
		if (!f.val()) {
			$('#frmFusp ez-file[name=file] span.error').text('verplicht');
			errorCount++;
		}
		
		
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	
	render() {
		if (!this.container) {
			this.container = show_popup('Bestand kiezen / uploaden', '');
			this.container.get(0).close_callback = this.callback_close;
		}
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.setVar('files', this.files);
		ezTpl.setObject('widget', this);
		ezTpl.render();
		
		$(this.container).find('.file-upload-pick-popup [name=qfile]').on('change', function() {
			if ( this.searchKeyupTimeout ) {
				clearTimeout( this.searchKeyupTimeout );
			}
			this.searchFiles();
		}.bind(this));
		
		$(this.container).find('.file-upload-pick-popup [name=qfile]').on('keyup', function(evt) {
			if ( evt.keyCode == 13 ) return;		// ignore enters
			
			if ( this.searchKeyupTimeout ) {
				clearTimeout( this.searchKeyupTimeout );
			}
			
			this.searchKeyupTimeout = setTimeout(function() {
				this.searchFiles();
			}.bind(this), 500);
		}.bind(this));
	}
	
	close() {
		close_popup();
	}
	
	show() {
		this.render();
		
		this.searchFiles();
	}
	
	
}

