
import { FileUploadPopup } from './FileUploadPopup.js';
import { FileEditPopup } from './FileEditPopup.js';


export class FileListWidget {

	ezTpl = null;
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.uploadFile" class="fa fa-plus"></a>
			</div>
			<h1>Bestanden</h1>
		</div>
		
		<input type="text" class="top-q" placeholder="Bestandsnaam, ref, ..." />
		
		<div ez-subtemplate="filecontainer">
			<div ez-if="files == null">
				Loading...
			</div>
			<div ez-if="files != null">
				<table class="table">
					<thead>
						<tr>
							<th>Bestandsnaam</th>
							<th>Ref.</th>
							<th>Grootte</th>
							<th>Aangemaakt op</th>
						</tr>
					</thead>
					<tbody ez-for="files" ez-item="f">
						<tr [onclick]="widget.editFile" class="pointer">
							<td file-id="{{f.dbFileId}}">
								{{f.originalFilename}}
							</td>
							<td>{{ f.refDescription }}</td>
							<td style="width: 100px;">
								{{ bytes2human(f.size) }}
							</td>
							<td style="width: 200px;">
								{{ format_datetime( new Date(f.created) ) }}
							</td>
						</tr>
					</tbody>
						<tr ez-if="files.length == 0">
							<td colspan="4" class="no-results">Geen resultaten gevonden</td>
						</tr>
				</table>
				
				<ez-pager></ez-pager>
			</div>
		</div>
	`;
	
	
		
	init(e, opts) {
		this.ezTpl = new EzTemplate( e );
		this.ezTpl.setVar('files', null);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		$('.top-q').val( getUrlParam('q') ?? '' );
		
		$('.top-q').on('change', function() {
			let q = $('.top-q').val();
			gotoRoute( '/files/' + '?q=' + encodeURIComponent(q) );
		}.bind(this));
		
		$('.top-q').focus();
		
		this.loadFiles();
	}

	
	editFile(evt, tr) {
		let fid = tr.querySelector('[file-id]').getAttribute('file-id');
		
		let fep = new FileEditPopup();
		fep.setDbFileId( fid );
		fep.show();
		fep.setCallbackClose(function() {
			this.loadFiles();
		}.bind(this));
		
//		gotoRoute( '/files/edit/?id='+uid );
	}
	
	
	uploadFile() {
		console.log('uploadFile()');
		let fup = new FileUploadPopup();
		fup.setCallbackClose(function() {
			this.loadFiles();
		}.bind(this));
		fup.show();
		
	}
	
	loadFiles() {
		postUrl('/service/files.do', {
				pageNo: getUrlParam('pageNo') ?? 0,
				q: getUrlParam('q') ?? ''
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showErrorWidget( json );
				}
				else {
					let eztpl = $('[ez-subtemplate=filecontainer]').get(0).eztemplate;
					
					eztpl.setObject('widget', this);
					eztpl.setVar('files', json.files);
					eztpl.setVar('response', json);
					eztpl.render();
				}
			}.bind(this) );
	}
	
	
	
	selectPage( pageNo ) {
		
		let params = [];
		let q = getUrlParam('q');
		if (q)
			params.push( 'q=' + encodeURIComponent(q) );
		params.push('pageNo=' + pageNo);
		
		
		gotoRoute( '/files/' + '?' + params.join('&') );
	}
	
	
}


