
import { ActivityPopup } from '../masterdata/activity/ActivityPopup.js';


export class ContractsDashboardWidget {
	
	tpl = `
		<div class="page-header">
			<h1>Dashboard</h1>
		</div>
		
		
		<div class="row">
		
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="recentcontracts">
				<div class="title">Recent aangepaste contracten</div>
				<div class="content">
					<span ez-if="typeof contracts == 'undefined'">Loading...</span>
					<span ez-if="typeof contracts != 'undefined'">
						<div class="no-results" ez-if="contracts.length == 0">Geen resultaten gevonden</div>
						<div ez-if="contracts.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th>Relatie</th>
										<th>Contractnaam</th>
										<th>Status</th>
										<th>Bewerkt op</th>
									</tr>
								</thead>
								
								<tbody ez-for="contracts" ez-item="c">
									<tr class="pointer" data-contract-id="{{c.contractId}}" [onclick]="widget.clickContract">
										<td>{{ c.customerName ?? '' }}</td>
										<td>{{ c.name  }}</td>
										<td>{{ _('contract_status.'+c.status) }}</td>
										<td>{{ format_datetime(c.edited) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
			
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="tasklist">
				<div class="title">Actuele taken</div>
				<div class="content">
					<span ez-if="typeof tasks == 'undefined'">Loading...</span>
					<span ez-if="typeof tasks != 'undefined'">
						<div class="no-results" ez-if="tasks.length == 0">Geen openstaande taken gevonden</div>
						<div ez-if="tasks.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th>Klant</th>
										<th>Contract</th>
										<th>Taak</th>
										<th>Alert</th>
										<th>Status</th>
									</tr>
								</thead>
								
								<tbody ez-for="tasks" ez-item="t">
									<tr class="tr-task pointer" contract-id="{{ t.contract_id }}" [onclick]="widget.clickTask">
										<td>{{ t.customer_name ?? '' }}</td>
										<td>{{ t.contract_name }}</td>
										<td>{{ t.description }}</td>
										<td>{{ format_date(str2date(t.next_alert_date), {dmy: true}) }}</td>
										<td>
											{{ _(t.next_status) }}
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
			
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="recentactivities">
				<div class="title" title="Laatste 50">Logboek</div>
				<div class="content">
					<span ez-if="typeof acts == 'undefined'">Loading...</span>
					<span ez-if="typeof acts != 'undefined'">
						<div class="no-results" ez-if="acts.length == 0">Geen resultaten gevonden</div>
						<div ez-if="acts.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th>#</th>
										<th>Omschrijving</th>
										<th>Tijdstip</th>
									</tr>
								</thead>
								
								<tbody ez-for="acts" ez-item="ac">
									<tr class="pointer" data-activity-id="{{ac.activityId}}" [onclick]="widget.clickActivity">
										<td>{{ ac.activityId }}</td>
										<td>{{ ac.shortDescription  }}</td>
										<td>{{ format_datetime(ac.created) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
		</div>
		
	`;
	
	
	constructor() {
		
	}
	
	init( selector ) {
		let et = new EzTemplate( selector );
		et.loadHtml( this.tpl );
		et.build();
		et.setObject('widget', this);
		et.render();
		
		this.loadRecentContracts();
		
		this.loadRecentTasks();
		
		if (toolboxConfig.admin) {
			this.loadRecentActivities();
		}
		else {
			$('[ez-subtemplate=recentactivities]').remove();
		}
	}
	
	
	clickContract(evt) {
		let cid = $(evt.currentTarget).data('contract-id');
		
		gotoRoute( '/contracts/edit/?id=' + cid );
	}
	
	loadRecentContracts() {
		postUrl( "/service/contracts/list.do", {
			a: 'recent'
		}).then( async function(e) {
			let json = await e.json();
			let tpl = $('[ez-subtemplate="recentcontracts"]').get(0).eztemplate;
			tpl.setObject('widget', this);
			tpl.setVar('contracts', json.contracts);
			tpl.render();
		}.bind(this));
		
	}
	
	loadRecentTasks() {
		postUrl("/service/contracts/task.do", {
			a: 'searchTasks',
			pageSize: 50,
			dashboardRequest: 1
		}).then( async function(e) {
			let json = await e.json();
			let tpl = $('[ez-subtemplate="tasklist"]').get(0).eztemplate;
			tpl.setObject('widget', this);
			tpl.setVar('tasks', json.tasks);
			tpl.render();
		}.bind(this));
	}
	
	loadRecentActivities() {
		postUrl("/service/activity.do")
		.then( async function(e) {
			let json = await e.json();
			let tpl = $('[ez-subtemplate="recentactivities"]').get(0).eztemplate;
			tpl.setVar('acts', json.acts);
			tpl.render();
		}.bind(this));
		
	}
	
	clickTask(evt) {
		let contractId = $(evt.currentTarget).attr('contract-id');
		
		gotoRoute( '/contracts/edit/?id='+contractId );
	}
	
	clickActivity(evt) {
		let activityId = $(evt.currentTarget).data('activity-id');
		
		let ap = new ActivityPopup( activityId );
		ap.showPopup();
	}
	
	
}

