


export class EmailPopup {
	
	tpl = `
	<div class="customer-email-popup">
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				<a href="javascript:void(0);" [onclick]="widget.saveEmail" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuw e-mailadres':'Bewerk e-mailadres'}}</h1>
		</div>

		<form id="frmEmail">
			<ez-text name="email_address" label="E-mailadres" [value]="email.emailAddress"></ez-text>
			
			<ez-text name="description" label="Omschrijving" [value]="email.description"></ez-text>
		</form>
	</div>
	`;
	
	isNew = true;
	
	
	
	email = {
		email_id: null,
		emailAddress: '',
		description: ''
	};
	
	container = null;
	
	callback_save = null;
	
	
	setEmail(e) {
		this.email = e;
		this.isNew = false;
	}
	
	setCallbackSave( c ) { this.callback_save = c; }
	
	
	saveEmail() {
		
		if (this.validate() > 0)
			return;
		
		if (this.callback_save) {
			this.callback_save( this.email, this );
		}
		
		close_popup();
	}
	
	validate() {
		this.email.emailAddress = $('#frmEmail input[name=email_address]').val();
		this.email.description = $('#frmEmail input[name=description]').val();
		
		this.email.emailAddress = $.trim(this.email.emailAddress);
		
		let errorCount = 0;
		$(this.container).find('span.error').text( '' );
		
		let em = $(this.container).find('input[name=email_address]').val();
		em = $.trim( em );
		
		if (em == '') {
			$('#frmEmail [name=email_address] .error').text('verplicht');
			errorCount++;
		} else if (validate_email(em) == false) {
			$('#frmEmail [name=email_address] .error').text('ongeldig adres');
			errorCount++;
		}
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	showPopup() {
		this.container = show_popup('E-mailadres', '');
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setVar('email', this.email);
		ezTpl.setVar('isNew', this.isNew);
		ezTpl.setObject('widget', this);
		ezTpl.render();
		
		focusFirstField('#frmEmail');
	}
	
	
}

