


export class CustomerView {
	
	tpl = `
		<div class="customer-view object-context-box">
			<div ez-if="c == null" style="font-style: italic;">
				null
			</div>
		
			<div ez-if="c != null">
				<div class="customer-name">{{ c.customerName }} {{ c.contactPerson ? ' - ' + c.contactPerson : '' }}</div>
				<span class="customer-address" ez-if="c.addresses.length > 0">
					<div>
						{{ c.addresses[0].street }}
						{{ c.addresses[0].streetNo }}
					</div>
					<div>
						{{ c.addresses[0].zipcode }}
						{{ c.addresses[0].city }}
					</div>
				</span>
				<span class="customer-phone" ez-if="c.phones.length > 0">
					<div>
						Tel. {{ c.phones[0].phonenr }}
					</div>
				</span>
				<span class="customer-email" ez-if="c.emails.length > 0">
					<div>
						Mail. {{ c.emails[0].phonenr }}
					</div>
				</span>
			</div>
		</div>
		
	`;
	
	container = null;
	customer = null;
	
	
	constructor( customer ) {
		this.customer = customer;
	}
	
	
	
	render( container ) {
		this.container = container;
		
//		console.log('CustomerView.customer', this.customer);
		
		let t = new EzTemplate( this.container );
		t.loadHtml( this.tpl );
		t.setVar( 'c', this.customer );
		t.render();
		
	}
	
	
}


