


export class ResetPasswordWidget {
	
	tpl = `
		<div class="authentication-widget">
			<div class="popup-background"></div>
			
			<div class="popup-authentication">

				<div class="reset-password-widget">
					<h1>{{_('Reset password')}}</h1>
					
					<div id="reset-password-content">
						Loading...
					</div>
				</div>
			</div>
		</div>
	`;
	
	tplResetForm = `
		<h1>{{_('Reset password')}}</h1>
	
		<div style="height: 10px;"></div>
	
		<div id="reset-password-widget-content">
			<table>
				<tr>
					<td>
						{{_('Username')}}
					</td>
					<td>
						{{username}}
					</td>
				</tr>
							
				<tr>
					<td>
						{{_('New password')}}
					</td>
					<td>
						<input type="password" name="p1" [onkeyup]="widget.hideErrors" />
						
						<img src="static/img/ajax-loader-small.gif" class="ajx-loader hidden" />
					</td>
				</tr>
				<tr>
					<td colspan="2" align="right">
						<div style="height: 10px;"></div>
						
						<div id="reset-password-error" class="error"></div>
						
						<button [onclick]="widget.cancel_Click">{{_('Cancel')}}</button>
						
						<button [onclick]="widget.change_Click">{{_('Change password')}}</button>
					</td>
				</tr>
			</table>
		</div>
	`;

	
	
	securityToken = null;
	username = null;
	
	
	
	init(e) {
		if ($('#reset-password-widget-content').length > 0)
			return;
		
		this.securityToken = getUrlParam('sec');
		
		this.container = $('<div class="auth-container" />');
		$(document.body).append( this.container );
		this.render();
		
		this.checkToken();
	}
	
	
	async checkToken() {
		
		try {
			let r = await postJson('/service/auth.do', {
				a: 'checkSecurityToken',
				sec: this.securityToken
			});
			
			
			let json = await r.json();
			
			if (json.success) {
				this.username = json.username;
				this.renderResetForm();
			}
			else {
				document.getElementById('reset-password-content').innerHTML = 'Error: ' + json.message + '<br/><br/><a href="'+appUrl('/')+'">Aanmelden &gt;</a>';
			}
		}
		catch (err) {
			document.getElementById('reset-password-content').innerText = 'Error: ' + err.message;
		}
	}
	
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
	}
	
	
	renderResetForm() {
		let eztpl = new EzTemplate( document.querySelector('.reset-password-widget') );
		eztpl.setObject('widget', this);
		eztpl.loadHtml( this.tplResetForm );
		eztpl.setVar('username', this.username);
		eztpl.render();
	}
	
	
	cancel_Click() {
		
		// TODO: void token?
		
		window.location = appUrl('/');
	}
	
	
	hideErrors() {
		document.getElementById('reset-password-error').innerHTML = '';
	}
	
	async change_Click() {
		let p1 = document.querySelector('input[name=p1]');
		let password = p1.value;
		
		if (password.length < 6) {
			document.getElementById('reset-password-error').innerText = 'Minimaal 6 karakters';
			return;
		}
		
		
		p1.setAttribute('disabled', 'disabled');
		
		
		try {
			let r = await postJson('/service/auth.do', {
				a: 'resetPassword',
				sec: this.securityToken,
				password: password
			})
			
			let json = await r.json();
			
			if (json.success) {
				window.location = appUrl('/');
			}
			else if (json.message) {
				document.getElementById('reset-password-error').innerText = 'Error: ' + json.message;
			}
			else {
				document.getElementById('reset-password-error').innerText = 'Unknown error occurred';
			}
		}
		catch (err ) {
//			console.log('error', err);
			document.getElementById('reset-password-error').innerText = 'Error: ' + err.message;
		}
		
		p1.removeAttribute('disabled');
	}
	
	
}

