
import { AuthenticationWidget } from '../widget/auth/AuthenticationWidget.js';

export class AppRouter {
	
	routes = [];
	
	constructor() {
		this.initRoutes();
	}
	
	initRoutes() {
		this.routes.push({ url: '/', 									widget: 'dashboards/ContractsDashboardWidget' });
		
		this.routes.push({ url: '/resetpassword/',						widget: 'auth/ResetPasswordWidget' });
		
		
		
		this.routes.push({ url: '/customers/', 							widget: 'customers/CustomerListWidget' });
		this.routes.push({ url: '/customers/edit/', 					widget: 'customers/CustomerEditWidget' });
		
		
		this.routes.push({ url: '/masterdata/activity/', 				widget: 'masterdata/activity/ActivityListWidget' });
		
		this.routes.push({ url: '/masterdata/users/', 					widget: 'masterdata/users/UserListWidget' });
		this.routes.push({ url: '/masterdata/users/edit/', 				widget: 'masterdata/users/UserEditWidget' });

		this.routes.push({ url: '/masterdata/groups/', 					widget: 'masterdata/groups/GroupListWidget' });
		this.routes.push({ url: '/masterdata/groups/edit/', 			widget: 'masterdata/groups/GroupEditWidget' });
		
		this.routes.push({ url: '/files/', 								widget: 'files/FileListWidget' });
		
		this.routes.push({ url: '/masterdata/sales/settings/', 			widget: 'sales/SalesSettingsWidget' });
		
		this.routes.push({ url: '/masterdata/sales/vat/', 				widget: 'sales/vat/VatListWidget' });
		this.routes.push({ url: '/masterdata/sales/vat/edit/', 			widget: 'sales/vat/VatEditWidget' });
		this.routes.push({ url: '/masterdata/sales/article/', 			widget: 'sales/article/ArticleListWidget' });
		this.routes.push({ url: '/masterdata/sales/article/edit/', 		widget: 'sales/article/ArticleEditWidget' });
		this.routes.push({ url: '/masterdata/sales/articlegroup/', 		widget: 'sales/articlegroup/ArticleGroupListWidget' });
		this.routes.push({ url: '/masterdata/sales/articlegroup/edit/',	widget: 'sales/articlegroup/ArticleGroupEditWidget' });
		
		this.routes.push({ url: '/masterdata/sales/slotplan/',			widget: 'sales/slot/SlotplanListWidget' });
		this.routes.push({ url: '/masterdata/sales/slotplan/config/',	widget: 'sales/slot/SlotplanConfigWidget' });

		this.routes.push({ url: '/masterdata/sales/slotplan/pricetype/edit/',widget: 'sales/slot/pricetype/SlotplanPricetypeEditWidget' });
		
		this.routes.push({ url: '/masterdata/sales/dayprice/',			widget: 'sales/dayprice/DayPriceListWidget' });
		this.routes.push({ url: '/masterdata/sales/dayprice/edit/',		widget: 'sales/dayprice/DayPriceEditWidget' });
		
		
		
		this.routes.push({ url: '/sales/offer/',						widget: 'sales/offer/OfferListWidget' });
		this.routes.push({ url: '/sales/offer/edit/',					widget: 'sales/offer/OfferEditWidget' });

		this.routes.push({ url: '/sales/order/',						widget: 'sales/order/OrderListWidget' });
		this.routes.push({ url: '/sales/order/edit/',					widget: 'sales/order/OrderEditWidget' });
		
		this.routes.push({ url: '/sales/invoice/',						widget: 'sales/invoice/InvoiceListWidget' });
		this.routes.push({ url: '/sales/invoice/edit/',					widget: 'sales/invoice/InvoiceEditWidget' });
		
		this.routes.push({ url: '/sales/salesplan/',					widget: 'sales/salesplan/SalesPlanWidget' });
		this.routes.push({ url: '/sales/salesplan/checkout/',			widget: 'sales/salesplan/SalesCheckoutWidget' });
		this.routes.push({ url: '/sales/salesplan/checkout/articles/',	widget: 'sales/salesplan/SalesCheckoutWidget' });
		this.routes.push({ url: '/sales/salesplan/checkout/customer/',	widget: 'sales/salesplan/SalesCheckoutWidget' });
		this.routes.push({ url: '/sales/salesplan/checkout/overview/',	widget: 'sales/salesplan/SalesCheckoutWidget' });
		
		this.routes.push({ url: '/sales/rental/',						widget: 'sales/rental/RentalContractsWidget' });
		this.routes.push({ url: '/sales/rental/new/',					widget: 'sales/rental/RentalContractNewWidget' });
		this.routes.push({ url: '/sales/rental/selectCustomer/',		widget: 'sales/rental/RentalSelectCustomerWidget' });
		this.routes.push({ url: '/sales/rental/summary/',				widget: 'sales/rental/RentalContractSummaryWidget' });
		this.routes.push({ url: '/sales/rental/edit/',					widget: 'sales/rental/RentalContractEditWidget' });
		this.routes.push({ url: '/sales/rental/occupation/',			widget: 'sales/rental/RentalOccupationWidget' });
		
			
		this.routes.push({ url: '/masterdata/email/settings/',			widget: 'email/EmailSettingsWidget' });
		this.routes.push({ url: '/email/edit/',							widget: 'email/EmailEditWidget' });
		this.routes.push({ url: '/email/view/',							widget: 'email/EmailViewWidget' });
		this.routes.push({ url: '/email/',								widget: 'email/EmailListWidget' });
		this.routes.push({ url: '/email/templates/',					widget: 'email/templates/EmailTemplateListWidget' });
		this.routes.push({ url: '/email/templates/edit/',				widget: 'email/templates/EmailTemplateEditWidget' });
		
		this.routes.push({ url: '/masterdata/', 						widget: 'masterdata/MasterDataWidget' });
		this.routes.push({ url: '/masterdata/appsettings/', 			widget: 'masterdata/AppSettingsWidget' });
		this.routes.push({ url: '/masterdata/license/',	 				widget: 'masterdata/LicenseWidget' });
		this.routes.push({ url: '/masterdata/websessions/',				widget: 'masterdata/WebSessionsWidget' });
		
		
		
		this.routes.push({ url: '/404/', 								widget: 'NotFoundWidget' });
	}
	

	startApp() {
		this.loadWidget( 'MenuWidget', '#menuContainer' );
		
		gotoRoute();
		
		
		window.addEventListener("popstate", (evt) => {
			
			// close popup on back?
	//		if ($('.popup-element').length > 0) {
	//			evt.preventDefault();
	//			history.go(1);
	//			close_popup();
	//			return;
	//		}
	//		else {
	//			// window.location is set at the moment
	//			gotoRoute();
	//		}
			// window.location is set at the moment
			gotoRoute();
		});
		
		// auto handle
		window.addEventListener('EzTemplate.updated', (evt) => {
			handleAnchors( 'body' );
		});
		
		
		window.dispatchEvent(new Event('App.started'));
		
		// not authenticated? => show login
		if (toolboxConfig.user == null) {
			let authw = new AuthenticationWidget();
			authw.init();
		}
	}
	

	lookupRoute( u ) {
		let r = null;
		
		for(let i in this.routes) {
			if ( this.routes[i].url == u || toolboxConfig.contextPath + this.routes[i].url == u ) {
				r = this.routes[i];
			}
		}
		
		r = apply_filter('AppRouter.lookupRoute', r, u);
		
		if (r == null) {
			console.log('Route not found', u);
		}

		return r;
	}
	
	gotoRoute( url, opts ) {
		opts = opts ? opts : {};
		
		destroy_popup();

		let u;

		if (url) {
			u = url;
			
			if (u.indexOf('?') != -1) {
				u = u.substring( 0, u.indexOf('?') );
			}
			
		}
		// determine path, excluding contextPath-url
		else {
			u = window.location.pathname;
			if (itxapp.config.contextPath.length > 0)
				u = u.substring( itxapp.config.contextPath.length );
		}

		console.log('loading url: ' + u);

		// lookup route
		let r = lookupRoute( u );

		// 404?
		if (r == null)
			r = lookupRoute( '/404/' );


		if (url) {
			let windowUrl = url;
			if (toolboxConfig.contextPath != '' && url.indexOf(toolboxConfig.contextPath) !== 0)
				windowUrl = toolboxConfig.contextPath + url;
			
			if (opts.replace) {
				window.history.replaceState({}, null, windowUrl);
			}
			else {
				window.history.pushState({}, null, windowUrl);
			}

		}

		$(window).trigger('window-history-pushed');

		// show
		loadWidget( r.widget, '#pagecontent' );

		setTimeout(function() {
			$(window).scrollTop(0);
		}, 200);
	}
	

	replaceRoute( url, opts ) {
		opts = opts ? opts : {};
		opts.replace = true;
		this.gotoRoute(url, opts);
	}
	
	
	loadWidget( widgetName, container, opts ) {
		if (!container)
			container = '#pagecontent';

		// determine path
		let jsfile = itxapp.config.contextPath + '/static/app/widget/' + widgetName + '.js';

		// import
		import( jsfile ).then (function(mod) {
			let i = jsfile.lastIndexOf('/');
			let widgetName = jsfile.substring(i+1);
			widgetName = widgetName.substring(0, widgetName.length-3);
			
			if ( typeof mod[widgetName] == 'undefined' ) {
				console.error( 'Error: import(), widget not exported, ', jsfile, widgetName );
			}
			
			if ($(container).length == 0) {
				console.log('Container disappeared, skipping render...', widgetName);
				return;
			}
			
			let w = Reflect.construct( mod[widgetName], [] );
			w.init( container, opts );
		}).catch(function(e) {
			console.log('error loadWidget', widgetName, e);
			console.error(e);
			
			showAlert('Error', 'Error: ' + e);
		});
	}

	showErrorWidget( err ) {
		if ( $('.popup-element').length > 0 ) {
			showAlert( _('Error'), err.message );
		}
		else {
			loadWidget( 'ErrorReportWidget', '#pagecontent', { error: err } );
		}
	}
	
	
	checkAuthentication() {
		
		return false;
	}
	
}

export const appRouter = new AppRouter();


