


export class ContractSettingsWidget {
	
	
	
	tpl = `
		<div class="contract-settings-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
				
				<h1>{{_('Contract settings')}}</h1>
			</div>
			
			<div ez-if="loading == true">Loading...</div>
			
			<div ez-if="loading == false">
				
				<form id="frmContractSettings">
					<fieldset>
						<legend>{{_('Alerts')}}</legend>
							<ez-checkbox name="dailyAlerts" 
											[checked]="settings.dailyAlerts"
											[onchange]="widget.dailyAlertsToggle"
											label="{{_('Daily alerts')}}"></ez-checkbox>
							
							<div class="daily-settings">
								
								<ez-checkbox name="dailyZeroUpdates"
												[checked]="settings.dailyZeroUpdates"
												label="Nul-berichten" infotext="Mail sturen als er geen openstaande taken zijn"></ez-checkbox>
								
								
								<div style="margin-bottom: 3px;">Dagen waarop alerts worden gestuurd</div>
								<div class="input-daily-alerts">
									<ez-checkbox name="dailyAlertsMo"
													[checked]="settings.dailyAlertsMo"
													label="{{_('daynoshort.1')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsTu"
													[checked]="settings.dailyAlertsTu"
													label="{{_('daynoshort.2')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsWe"
													[checked]="settings.dailyAlertsWe"
													label="{{_('daynoshort.3')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsTh"
													[checked]="settings.dailyAlertsTh"
													label="{{_('daynoshort.4')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsFr"
													[checked]="settings.dailyAlertsFr"
													label="{{_('daynoshort.5')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsSa"
													[checked]="settings.dailyAlertsSa"
													label="{{_('daynoshort.6')}}"></ez-checkbox>
									<ez-checkbox name="dailyAlertsSu"
													[checked]="settings.dailyAlertsSu"
													label="{{_('daynoshort.0')}}"></ez-checkbox>
								</div>
							</div>
								
							
							<ez-checkbox name="weeklySummary" 
											[checked]="settings.weeklySummary"
											[onchange]="widget.weeklyAlertsToggle" 
											label="{{_('Weekly summary')}}"></ez-checkbox>
							
							<div class="weekly-settings">
								<ez-select name="weeklySummaryDay" [value]="settings.weeklySummaryDay" label="{{_('Weekly summary day')}}">
									<option value="1">{{_('Monday')}}</option>
									<option value="2">{{_('Tuesday')}}</option>
									<option value="3">{{_('Wednesday')}}</option>
									<option value="4">{{_('Thursday')}}</option>
									<option value="5">{{_('Friday')}}</option>
									<option value="6">{{_('Saturday')}}</option>
									<option value="0">{{_('Sunday')}}</option>
								</ez-select>
							</div>
						</fieldset>
						
						
						<div style="font-style: italic; font-size: 10px; margin-top: 35px;">
							* Dagelijkse alerts laat alle 'Open' en 'In behandeling' taken zien van afgelopen 14 dagen. Wekelijkse update
							geeft een overzicht van alle openstaande taken, ongeacht hoelang deze open staan.
						</div>
				</form>
				
			</div>
			
		
		</div>
	`;
	
	
	
	container = null;
	loading = true;
	
	settings = {};
	
	
	init(e) {
		
		this.container = e;
		
		this.render();
		
		this.loadSettings();
	}
	
	
	
	async loadSettings() {
		
		let r = await postUrl( '/service/contracts/settings.do', {
			a: 'index'
		});
		
		
		let json = await r.json();
		
//		console.log('hmz', json);
		
		if (json.success) {
			this.settings = json.settings;
			this.loading = false;
			
			this.render();
		}
		
	}
	
	
	
	render() {
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('settings', this.settings);
				
		eztpl.render();
		
		
		this.dailyAlertsToggle();
		this.weeklyAlertsToggle();
	}
	
	
	async save_Click() {
		
		let frm = document.getElementById('frmContractSettings');
		
		let r = {};
		r.dailyAlerts = frm.querySelector('input[name=dailyAlerts]').checked ? 1 : 0;
		
		r.dailyZeroUpdates = frm.querySelector('input[name=dailyZeroUpdates]').checked ? 1 : 0;
		r.dailyAlertsMo = frm.querySelector('input[name=dailyAlertsMo]').checked ? 1 : 0;
		r.dailyAlertsTu = frm.querySelector('input[name=dailyAlertsTu]').checked ? 1 : 0;
		r.dailyAlertsWe = frm.querySelector('input[name=dailyAlertsWe]').checked ? 1 : 0;
		r.dailyAlertsTh = frm.querySelector('input[name=dailyAlertsTh]').checked ? 1 : 0;
		r.dailyAlertsFr = frm.querySelector('input[name=dailyAlertsFr]').checked ? 1 : 0;
		r.dailyAlertsSa = frm.querySelector('input[name=dailyAlertsSa]').checked ? 1 : 0;
		r.dailyAlertsSu = frm.querySelector('input[name=dailyAlertsSu]').checked ? 1 : 0;
		
		r.weeklySummary = frm.querySelector('input[name=weeklySummary]').checked ? 1 : 0;
		r.weeklySummaryDay = frm.querySelector('select[name=weeklySummaryDay]').value;
		
		await postJson('/service/contracts/settings.do', {
			a: 'save',
			settings: r
		});
		
		reportUserMessage(_('Changes saved'));
		
		replaceRoute('/masterdata/contracts/settings/');
	}
	
	
	back_Click() {
		gotoRoute('/masterdata/');
	}
	
	
	dailyAlertsToggle() {
		
		let inp = $('input[name=dailyAlerts]');
		
		if (inp.length == 0)
			return;
		
		if (inp.prop('checked')) {
			$('.daily-settings').show();
		}
		else {
			$('.daily-settings').hide();
		}
		
	}
	
	
	weeklyAlertsToggle() {

		let inp = $('input[name=weeklySummary]');

		if (inp.length == 0)
			return;

		if (inp.prop('checked')) {
			$('.weekly-settings').show();
		}
		else {
			$('.weekly-settings').hide();
		}
	}
}




