

export class UserActionEvents {
	
	
	constructor() {
		
		this.addActionButton();
	}
	
	
	addActionButton() {
		let container = document.querySelector('.user-edit-widget .action-box');
		if (!container)
			return;
		
		
		let s = document.createElement('span');
		let anch = document.createElement('a');
		anch.innerText = _('E-mail Daily Alert');
		s.appendChild(anch);
		anch.onclick = () => {
			this.confirmDailyAlerts();
		};
		container.appendChild( s );
		
		let s2 = document.createElement('span');
		let anch2 = document.createElement('a');
		anch2.innerText = _('E-mail Weekly Update');
		s2.appendChild(anch2);
		anch2.onclick = () => {
			this.confirmWeeklyAlerts();
		};
		container.appendChild( s2 );
	}
	
	confirmDailyAlerts() {
		let d = document.createElement('div');
		d.innerHTML = _('Are you sure to send the daily alert?');
		
		showConfirmation(_('Send mail'), d, () => {
			this.sendDailyAlerts();
		});
	}

	confirmWeeklyAlerts() {
		let d = document.createElement('div');
		d.innerHTML = _('Are you sure to send the weekly update?');
		
		showConfirmation(_('Send mail'), d, () => {
			this.sendWeeklyAlerts();
		});
	}
	
	async sendDailyAlerts( ) {
		let frm = $('#frmUser');
		let userId = frm.find('input[name=user_id]').val();
		
		let r = await postJson('/service/contracts/task.do', {
			a: 'sendDailyAlerts',
			userId: userId
		});
		
		let json = await r.json();
		
		
		if (json.success) {
			reportUserMessage(_('Mail sent'));
		}
		else {
			if (json.message) {
				reportUserMessage(_('Error sending mail') + ': ' + json.message );
			}
			else {
				reportUserMessage(_('Error sending mail') );
			}
		}
	}

	async sendWeeklyAlerts( ) {
		let frm = $('#frmUser');
		let userId = frm.find('input[name=user_id]').val();
		
		let r = await postJson('/service/contracts/task.do', {
			a: 'sendWeeklyUpdate',
			userId: userId
		});
		
		let json = await r.json();
		
		
		if (json.success) {
			reportUserMessage(_('Mail sent'));
		}
		else {
			if (json.message) {
				reportUserMessage(_('Error sending mail') + ': ' + json.message );
			}
			else {
				reportUserMessage(_('Error sending mail') );
			}
		}
	}
	
	
}

