/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class NumberUtil {
    protected static final DecimalFormat dfNumber = new DecimalFormat("###,###,###,##0.00");

    public static Integer tryParseInt(Object v, Integer defaultVal) {
        if (v == null) {
            return defaultVal;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        Integer val = NumberUtil.tryParseInt(v.toString());
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static Integer tryParseInt(String v) {
        if (v == null) {
            return null;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Long tryParseLong(String v) {
        if (v == null) {
            return null;
        }
        try {
            return Long.parseLong(v);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Double tryParseDouble(String v) {
        if (v == null) {
            return null;
        }
        v = v.replace(",", "");
        try {
            return Double.parseDouble(v);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Double tryCurrencyToDouble(String v) {
        v = v.replaceAll("[^0-9,\\.]", "");
        v = v.replaceAll(",", ".");
        return NumberUtil.tryParseDouble(v);
    }

    public static List<Integer> csl2int(String line) {
        if (line == null) {
            return new ArrayList<Integer>();
        }
        String[] toks = line.split(",");
        ArrayList<Integer> ints = new ArrayList<Integer>();
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            Integer i = NumberUtil.tryParseInt(t);
            if (i != null) {
                ints.add(i);
            }
            ++n2;
        }
        return ints;
    }

    public static String formatPrice(Double p) {
        if (p == null) {
            p = 0.0;
        }
        String r = dfNumber.format(p);
        char ds = dfNumber.getDecimalFormatSymbols().getDecimalSeparator();
        if (ds == '.') {
            r = r.replace(',', ' ');
            r = r.replace('.', ',');
        } else {
            r = r.replace('.', ' ');
        }
        return "\u20ac " + r;
    }

    public static Double roundPrice(Double p) {
        BigDecimal d = new BigDecimal(p);
        d = d.setScale(2, RoundingMode.HALF_UP);
        return d.doubleValue();
    }

    public static boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        return s.matches("^\\d+$") || s.matches("^\\d+\\.\\d*$");
    }

    public static void main(String[] args) {
        try {
            System.out.println("Test: " + NumberUtil.isNumeric("1234."));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

