/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jtbcore.util.NumberUtil;

public class DateUtil {
    public static final SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    public static final SimpleDateFormat dateForm2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat dateForm3 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateForm4 = new SimpleDateFormat("dd-MM-yyyy");
    public static final SimpleDateFormat dateFormMin = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected static Map<String, Integer> monthMap;

    static {
        HashMap<String, Integer> tmpMap = new HashMap<String, Integer>();
        tmpMap.put("jan", 1);
        tmpMap.put("feb", 2);
        tmpMap.put("mar", 3);
        tmpMap.put("mrt", 3);
        tmpMap.put("apr", 4);
        tmpMap.put("may", 5);
        tmpMap.put("mei", 5);
        tmpMap.put("jun", 6);
        tmpMap.put("jul", 7);
        tmpMap.put("aug", 8);
        tmpMap.put("sep", 9);
        tmpMap.put("oct", 10);
        tmpMap.put("okt", 10);
        tmpMap.put("nov", 11);
        tmpMap.put("dec", 12);
        monthMap = tmpMap;
    }

    public static String daynameLong(Date d) {
        if (d.getDay() == 0) {
            return "Sunday";
        }
        if (d.getDay() == 1) {
            return "Monday";
        }
        if (d.getDay() == 2) {
            return "Tuesday";
        }
        if (d.getDay() == 3) {
            return "Wednesday";
        }
        if (d.getDay() == 4) {
            return "Thursday";
        }
        if (d.getDay() == 5) {
            return "Friday";
        }
        if (d.getDay() == 6) {
            return "Saturday";
        }
        return "? " + d.getDay();
    }

    public static String daynameShort(Date d) {
        String s = DateUtil.daynameLong(d);
        return s.substring(0, 2);
    }

    public static boolean isSameDate(Date d1, Date d2) {
        String s2;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s1 = sdf.format(d1);
        return s1.equals(s2 = sdf.format(d2));
    }

    public static boolean isToday(Date d1) {
        return DateUtil.isSameDate(d1, new Date());
    }

    public static String twsNow() {
        return dateForm.format(Calendar.getInstance().getTime());
    }

    public static String nowDatetime() {
        return dateForm2.format(Calendar.getInstance().getTime());
    }

    public static String nowDate() {
        return dateForm3.format(Calendar.getInstance().getTime());
    }

    public static Date now() {
        return new Date();
    }

    public static Date oclock() {
        Date d = new Date();
        d.setHours(0);
        d.setMinutes(0);
        d.setSeconds(0);
        return d;
    }

    public static Date string2datetime(String d) {
        if (d == null) {
            return null;
        }
        Date r = null;
        if (d.matches("^\\d{12,}$")) {
            return DateUtil.msecepoc2string(d);
        }
        if (d.matches("^.{0,1}Date\\(\\d+\\).{0,1}$")) {
            String n = d.replaceAll("^.{0,1}Date\\((\\d+)\\).{0,1}$", "$1");
            Long timestamp = NumberUtil.tryParseLong(n);
            r = new Date(timestamp);
            return r;
        }
        if (d.matches("^\\d{8}.*")) {
            r = DateUtil.string2date(d.substring(0, 8));
        } else if (d.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}.*")) {
            r = DateUtil.string2date(d.substring(0, 15));
        } else if (d.matches("^\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}.*")) {
            r = DateUtil.string2date(d.substring(0, 15));
        } else if (d.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}$")) {
            r = DateUtil.string2datetime(d.replace('T', ' '));
        } else if (d.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}$")) {
            r = DateUtil.string2datetime(d.replace('T', ' '));
        } else if (d.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\+.*")) {
            try {
                DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssz");
                ZonedDateTime zdt = ZonedDateTime.parse(d, f);
                r = new Date(zdt.toEpochSecond() * 1000L);
                return r;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (d.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z$")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                r = sdf.parse(d.replaceAll("Z$", "+0000"));
                return r;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (r != null) {
            String time2;
            boolean timeFound = false;
            String time = d.replaceAll(".*(\\d{2}:\\d{2}:\\d{2}).*", "$1");
            if (time.matches("^\\d{2}:\\d{2}:\\d{2}$")) {
                String[] timeTokens = time.split(":");
                int h = NumberUtil.tryParseInt(timeTokens[0]);
                int m = NumberUtil.tryParseInt(timeTokens[1]);
                int s = NumberUtil.tryParseInt(timeTokens[2]);
                r.setHours(h);
                r.setMinutes(m);
                r.setSeconds(s);
                timeFound = true;
            }
            if (!timeFound && (time2 = d.replaceAll(".*(\\d{2}:\\d{2}).*", "$1")).matches("^\\d{2}:\\d{2}$")) {
                String[] timeTokens = time2.split(":");
                int h = NumberUtil.tryParseInt(timeTokens[0]);
                int m = NumberUtil.tryParseInt(timeTokens[1]);
                int s = 0;
                r.setHours(h);
                r.setMinutes(m);
                r.setSeconds(s);
                timeFound = true;
            }
            if (!timeFound) {
                r = null;
            }
        }
        return r;
    }

    public static Date string2date(String d) {
        if (d == null) {
            return null;
        }
        int year = -1;
        int month = -1;
        int day = -1;
        if (d.matches("^.{0,1}Date\\(\\d+\\).{0,1}$")) {
            String n = d.replaceAll("^.{0,1}Date\\((\\d+)\\).{0,1}$", "$1");
            Long timestamp = NumberUtil.tryParseLong(n);
            return new Date(timestamp);
        }
        if (d.matches("^\\d{4}-\\d{2}-\\d{2}.*")) {
            tokens = d.substring(0, 10).split("-");
            year = NumberUtil.tryParseInt(tokens[0]);
            month = NumberUtil.tryParseInt(tokens[1]);
            day = NumberUtil.tryParseInt(tokens[2]);
        } else if (d.matches("^\\d{2}-\\d{2}-\\d{4}.*")) {
            tokens = d.substring(0, 10).split("-");
            year = NumberUtil.tryParseInt(tokens[2]);
            month = NumberUtil.tryParseInt(tokens[1]);
            day = NumberUtil.tryParseInt(tokens[0]);
        } else if (d.matches("^\\d{2}-\\d{2}-\\d{4}$")) {
            tokens = d.split("-");
            year = NumberUtil.tryParseInt(tokens[2]);
            month = NumberUtil.tryParseInt(tokens[1]);
            day = NumberUtil.tryParseInt(tokens[0]);
        } else if (d.matches("^\\d{6}$")) {
            year = NumberUtil.tryParseInt(d.substring(0, 2)) + 2000;
            month = NumberUtil.tryParseInt(d.substring(2, 4));
            day = NumberUtil.tryParseInt(d.substring(4, 6));
        } else if (d.matches("^\\d{8}$")) {
            year = NumberUtil.tryParseInt(d.substring(0, 4));
            month = NumberUtil.tryParseInt(d.substring(4, 6));
            day = NumberUtil.tryParseInt(d.substring(6, 8));
        } else {
            if (d.matches("^\\d{12,}$")) {
                Long l = NumberUtil.tryParseLong(d);
                return new Date(l);
            }
            for (String k : monthMap.keySet()) {
                if (!d.toLowerCase().contains(k)) continue;
                Integer possibleMonth = monthMap.get(k);
                Integer possibleYear = null;
                Integer possibleDay = null;
                if (d.matches("\\D*\\d{1,2}\\D*\\d{4}.*")) {
                    possibleYear = NumberUtil.tryParseInt(d.replaceAll("\\D*\\d{1,2}\\D*(\\d{4}).*", "$1"));
                    possibleDay = NumberUtil.tryParseInt(d.replaceAll("\\D*(\\d{1,2})\\D*\\d{4}.*", "$1"));
                } else if (d.matches("\\D*\\d{4}\\D*\\d{1,2}\\D*")) {
                    possibleYear = NumberUtil.tryParseInt(d.replaceAll("\\D*(\\d{4})\\D*\\d{1,2}\\D*", "$1"));
                    possibleDay = NumberUtil.tryParseInt(d.replaceAll("\\D*\\d{4}\\D*(\\d{1,2})\\D*", "$1"));
                }
                if (possibleYear == null || possibleDay == null || possibleYear <= 1970 || possibleYear >= 2500 || possibleDay < 1 || possibleDay > 31) continue;
                year = possibleYear;
                month = possibleMonth;
                day = possibleDay;
            }
        }
        if (year == -1) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static int string2ymd(String s) {
        Date d = DateUtil.string2date(s);
        return DateUtil.date2ymd(d);
    }

    public static Date msecepoc2string(String s) {
        Long l = NumberUtil.tryParseLong(s);
        if (l == null) {
            return null;
        }
        return DateUtil.msecepoc2string(l);
    }

    public static Date msecepoc2string(Long s) {
        Date d = new Date();
        d.setTime(s);
        return d;
    }

    public static String date2string(String d) {
        Date d2 = DateUtil.string2date(d);
        return DateUtil.date2string(d2);
    }

    public static String date2string(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(d);
    }

    public static String datetime2string(Date d) {
        if (d == null) {
            return null;
        }
        return dateForm2.format(d);
    }

    public static String datetime2stringmin(Date d) {
        if (d == null) {
            return null;
        }
        return dateFormMin.format(d);
    }

    public static Integer date2ymd(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return Integer.parseInt(sdf.format(d));
    }

    public static Date ymd2date(int ymd) {
        int year = ymd / 10000;
        int month = ymd / 100 % 100;
        int day = ymd % 100;
        Date d = new Date(year - 1900, month - 1, day);
        d.setHours(12);
        d.setMinutes(0);
        d.setSeconds(0);
        return d;
    }

    public static Date ymdhm2date(long ymdhm) {
        int year = (int)(ymdhm / 100000000L);
        int month = (int)(ymdhm / 1000000L) % 100;
        int day = (int)(ymdhm / 10000L) % 100;
        int hour = (int)(ymdhm / 100L) % 100;
        int min = (int)(ymdhm % 100L);
        Date d = new Date(year - 1900, month - 1, day);
        d.setHours(hour);
        d.setMinutes(min);
        d.setSeconds(0);
        return d;
    }

    public static String ymd2string(int ymd) {
        Date d = DateUtil.ymd2date(ymd);
        return DateUtil.date2string(d);
    }

    public static String ymdhm2string(long ymdhm) {
        Date d = DateUtil.ymdhm2date(ymdhm);
        return DateUtil.datetime2stringmin(d);
    }

    public static int ymdNow() {
        return DateUtil.date2ymd(new Date());
    }

    public static int daysBetween(LocalDateTime d1, LocalDateTime d2) {
        Long l = Duration.between(d1, d2).toDays();
        return l.intValue();
    }

    public static int daysBetween(LocalDateTime d1, Date d2) {
        LocalDateTime ld2 = Instant.ofEpochMilli(d2.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return DateUtil.daysBetween(d1, ld2);
    }

    public static int daysBetween(Date d1, Date d2) {
        LocalDate ld1 = d1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate ld2 = d2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)ChronoUnit.DAYS.between(ld1, ld2);
    }

    public static int daysBetween(String strD1, String strD2) {
        Date d1 = DateUtil.string2date(strD1);
        Date d2 = DateUtil.string2date(strD2);
        return DateUtil.daysBetween(d1, d2);
    }

    public static int daysBetween(String strD1, Date d2) {
        Date d1 = DateUtil.string2date(strD1);
        return DateUtil.daysBetween(d1, d2);
    }

    public static int daysBetween(Date d1, String strD2) {
        Date d2 = DateUtil.string2date(strD2);
        return DateUtil.daysBetween(d1, d2);
    }

    public static Date previousYear(Date d, Integer years) {
        return DateUtil.previousMonth(d, years * 12);
    }

    public static Date nextYear(Date d, Integer years) {
        return DateUtil.nextMonth(d, years * 12);
    }

    public static Date previousMonth(Date d, Integer months) {
        return DateUtil.nextMonth(d, months * -1);
    }

    public static Date nextMonth(Date d, Integer months) {
        Date d2 = (Date)d.clone();
        d2.setHours(12);
        d2.setMinutes(0);
        d2.setSeconds(0);
        Integer startDate = d2.getDate();
        Date d3 = (Date)d.clone();
        d3.setMonth(d3.getMonth() + 1);
        d3.setDate(0);
        Integer daysInMonth = d3.getDate();
        d2.setDate(15);
        d2.setMonth(d2.getMonth() + months);
        d3 = (Date)d2.clone();
        d3.setMonth(d3.getMonth() + 1);
        d3.setDate(0);
        Integer daysInNewMonth = d3.getDate();
        if (startDate == daysInMonth) {
            d2.setDate(daysInNewMonth);
        } else if (startDate <= daysInNewMonth) {
            d2.setDate(startDate);
        } else {
            d2.setDate(daysInNewMonth);
        }
        return d2;
    }

    public static Date previousWeek(Date d, Integer weeks) {
        return DateUtil.nextDay(d, weeks * -7);
    }

    public static Date nextWeek(Date d, Integer weeks) {
        return DateUtil.nextDay(d, weeks * 7);
    }

    public static Date previousDay(Integer days) {
        return DateUtil.previousDay(new Date(), days);
    }

    public static Date previousDay(Date d, Integer days) {
        return DateUtil.nextDay(d, days * -1);
    }

    public static Date nextDay(Integer days) {
        return DateUtil.nextDay(new Date(), days);
    }

    public static Date nextDay(Date d, Integer days) {
        Date d2 = (Date)d.clone();
        d2.setHours(12);
        d2.setMinutes(0);
        d2.setSeconds(0);
        d2.setDate(d2.getDate() + days);
        return d2;
    }

    public static Date calcDate(Date refDate, String unit, Integer time) {
        if ("day".equals(unit)) {
            return DateUtil.nextDay(refDate, time);
        }
        if ("week".equals(unit)) {
            return DateUtil.nextWeek(refDate, time);
        }
        if ("month".equals(unit)) {
            return DateUtil.nextMonth(refDate, time);
        }
        if ("year".equals(unit)) {
            return DateUtil.nextYear(refDate, time);
        }
        return null;
    }

    public static Integer unixTimestamp() {
        Long unixTime = System.currentTimeMillis() / 1000L;
        return unixTime.intValue();
    }

    public static int minsBetween(Date timeStart, Date timeEnd) {
        long l = timeEnd.getTime() - timeStart.getTime();
        Double mins = (double)(l /= 1000L) / 60.0;
        Long rounded = Math.round(mins);
        return rounded.intValue();
    }

    public static int minsBetween(int timeStart, int timeEnd) {
        int m1 = timeStart % 100;
        int m2 = timeEnd % 100;
        int hdiff = timeEnd / 100 - timeStart / 100;
        int b = hdiff * 60;
        return b += m2 - m1;
    }

    public static int minMinutes(int start, int minutes) {
        return DateUtil.plusMinutes(start, minutes * -1);
    }

    public static int plusMinutes(int start, int minutes) {
        if ((minutes %= 1440) < 0) {
            minutes += 1440;
        }
        int sm = start % 100;
        int sh = (start - sm) / 100;
        int m = sh * 60 + sm;
        m += minutes;
        int r = (m %= 1440) % 60;
        r += (m - r) / 60 * 100;
        return r;
    }

    public static boolean validTime(String t) {
        if (t == null || !t.matches("^\\d{2}:\\d{2}$")) {
            return false;
        }
        String[] toks = t.split(":");
        Integer h = NumberUtil.tryParseInt(toks[0]);
        Integer m = NumberUtil.tryParseInt(toks[1]);
        if (h < 0 || h > 24) {
            return false;
        }
        return m >= 0 && m <= 59;
    }

    public static boolean validDateTime(String t) {
        if (t == null) {
            return false;
        }
        if (t.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}$")) {
            return true;
        }
        if (t.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$")) {
            return true;
        }
        if (t.matches("^\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}$")) {
            return true;
        }
        return t.matches("^\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}:\\d{2}$");
    }

    public static boolean validDate(String t) {
        if (t == null) {
            return false;
        }
        if (t.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            return true;
        }
        return t.matches("^\\d{2}-\\d{2}-\\d{4}$");
    }

    public static void main(String[] args) {
        try {
            System.out.println("Test: " + String.valueOf(DateUtil.string2date("05-08-2025 00:00")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

