/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheUtil {
    protected static CacheUtil instance = null;
    protected Map<String, CacheObject> map = new ConcurrentHashMap<String, CacheObject>();

    public static void setCache(String key, Object val, int timeoutSec) {
        CacheUtil.getInstance()._setCache(key, val, timeoutSec);
    }

    public static Object getCache(String key) {
        return CacheUtil.getInstance()._getCache(key);
    }

    public static void removeCache(String key) {
        CacheUtil.getInstance()._removeCache(key);
    }

    public static void cleanup() {
        CacheUtil.getInstance()._cleanup();
    }

    public synchronized void _setCache(String key, Object val, int timeoutSec) {
        CacheObject co = new CacheObject();
        co.timeoutSec = timeoutSec;
        co.value = val;
        this.map.put(key, co);
    }

    public synchronized Object _getCache(String key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        CacheObject co = this.map.get(key);
        if (co.timeoutSec <= 0) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (co.startTime + (long)(co.timeoutSec * 1000) < now) {
            this.map.remove(key);
            return null;
        }
        return co.value;
    }

    public synchronized void _removeCache(String key) {
        if (this.map.containsKey(key)) {
            this.map.remove(key);
        }
    }

    public synchronized void _cleanup() {
        long now = System.currentTimeMillis();
        Set<String> keys = this.map.keySet();
        for (String key : keys) {
            CacheObject co = this.map.get(key);
            if (co.startTime + (long)(co.timeoutSec * 1000) >= now) continue;
            this.map.remove(key);
        }
    }

    public static synchronized CacheUtil getInstance() {
        if (instance == null) {
            instance = new CacheUtil();
        }
        return instance;
    }

    protected class CacheObject {
        public int timeoutSec = -1;
        public long startTime = System.currentTimeMillis();
        public Object value = null;
    }
}

