/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.pdf;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public class PdfPage {
    protected PDDocument doc = new PDDocument();
    protected PDFont font;
    protected float fontSize = 12.0f;
    protected float posY;
    protected float pageWidth;
    protected float pageHeight;
    protected PDPageContentStream contentStream = null;

    public PdfPage(String filename) {
        this.setFont("Helvetica", 12.0f);
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public PDPage getPage() throws IOException {
        int c = this.doc.getPages().getCount();
        if (c <= 0) {
            this.addPage();
            c = 1;
        }
        return this.doc.getPage(c - 1);
    }

    public void addPage() throws IOException {
        this.closeContentStream();
        this.addPage(PDRectangle.A4);
    }

    public void addPage(PDRectangle rect) {
        PDPage p = new PDPage(rect);
        this.doc.addPage(p);
        this.pageWidth = p.getMediaBox().getWidth();
        this.posY = this.pageHeight = p.getMediaBox().getHeight();
    }

    public PDPageContentStream getContentStream() throws IOException {
        if (this.contentStream == null) {
            this.contentStream = new PDPageContentStream(this.doc, this.getPage());
        }
        return this.contentStream;
    }

    public void closeContentStream() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
            this.contentStream = null;
        }
    }

    public void drawLine(float startX, float startY, float endX, float endY) throws IOException {
        PDPageContentStream cs = this.getContentStream();
        cs.setLineWidth(0.5f);
        cs.setStrokingColor(Color.black);
        cs.moveTo(startX, startY);
        cs.lineTo(endX, endY);
        cs.stroke();
    }

    public void setFont(String fontName, float fontSize) {
        Standard14Fonts.FontName fontHelvetica = Standard14Fonts.getMappedFontName((String)fontName);
        this.font = new PDType1Font(fontHelvetica);
        this.fontSize = fontSize;
    }

    public double stringWidth(String str) throws IOException {
        if (str == null) {
            return 0.0;
        }
        return (double)this.font.getStringWidth(str) / 1000.0 * (double)this.fontSize;
    }

    public void writeTextAlignRight(float x, float y, float width, String str) throws IOException {
        str = str.replaceAll("\\r\\n", "\n");
        String[] lines = str.split("\n");
        int n = 0;
        while (n < lines.length) {
            if (lines[n].trim().length() != 0) {
                double textWidth = this.stringWidth(lines[n]);
                int textX = new Double((double)(x + width) - textWidth).intValue();
                int textY = new Double(y - (float)n * this.fontSize).intValue();
                this.addLine(textX, textY, lines[n]);
            }
            ++n;
        }
    }

    public void addLine(int x, int y, String str) throws IOException {
        PDPageContentStream cs = this.getContentStream();
        cs.beginText();
        cs.setFont(this.font, this.fontSize);
        cs.setLeading(this.fontSize);
        cs.setNonStrokingColor(Color.black);
        cs.newLineAtOffset((float)x, (float)y);
        cs.showText(str);
        cs.endText();
    }

    /*
     * Unable to fully structure code
     */
    public String truncateString(double maxWidth, String str) throws IOException {
        if (!(maxWidth <= 0.0)) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            str = str.substring(0, str.length() - 1);
lbl4:
            // 2 sources

            ** while (this.stringWidth((String)str) > maxWidth)
        }
lbl5:
        // 1 sources

        return str;
    }

    public void addLineTruncated(int x, int y, double maxWidth, String str) throws IOException {
        if (maxWidth <= 0.0) {
            return;
        }
        this.addLine(x, y, this.truncateString(maxWidth, str));
    }

    public void writeText(float x, float y, String str) throws IOException {
        str = str.replaceAll("\\r\\n", "\n");
        String[] lines = str.split("\n");
        PDPageContentStream cs = this.getContentStream();
        cs.beginText();
        cs.newLineAtOffset(x, y);
        cs.setFont(this.font, this.fontSize);
        cs.setLeading(this.fontSize);
        cs.setNonStrokingColor(Color.black);
        int n = 0;
        while (n < lines.length) {
            cs.showText(lines[n]);
            if (n + 1 < lines.length) {
                cs.newLine();
            }
            ++n;
        }
        cs.endText();
    }

    public void save(File f) throws IOException {
        this.closeContentStream();
        this.doc.save(f);
    }

    public void save(OutputStream os) throws IOException {
        this.closeContentStream();
        this.doc.save(os);
    }
}

