/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtbcore.model.validator.ValidatorFunction;
import jtbcore.model.validator.ValidatorResult;

public class BaseValidator<T> {
    protected String key;
    protected Map<String, List<ValidatorFunction>> validatorFuncs = new HashMap<String, List<ValidatorFunction>>();
    protected List<ValidatorResult> validatorResults;
    protected boolean containsError = false;

    public void addValidator(String fieldName, ValidatorFunction<T> vf) {
        if (!this.validatorFuncs.containsKey(fieldName)) {
            ArrayList l = new ArrayList();
            this.validatorFuncs.put(fieldName, l);
        }
        this.validatorFuncs.get(fieldName).add(vf);
    }

    public List<ValidatorResult> getValidatorResults() {
        return this.validatorResults;
    }

    public List<ValidatorResult> getErrors() {
        ArrayList<ValidatorResult> l = new ArrayList<ValidatorResult>();
        for (ValidatorResult vr : this.validatorResults) {
            if (!vr.getError().booleanValue()) continue;
            l.add(vr);
        }
        return l;
    }

    public boolean validate(T obj) {
        this.validatorResults = new ArrayList<ValidatorResult>();
        this.containsError = false;
        Set<String> keys = this.validatorFuncs.keySet();
        for (String k : keys) {
            List<ValidatorFunction> funcs = this.validatorFuncs.get(k);
            for (ValidatorFunction func : funcs) {
                ValidatorResult r;
                if (func == null || (r = func.validate(obj)) == null) continue;
                r.setFieldName(k);
                this.validatorResults.add(r);
                if (!r.getError().booleanValue()) continue;
                this.containsError = true;
            }
        }
        return !this.containsError;
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.validatorFuncs.keySet());
    }
}

