/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.List;
import jtbcore.model.KeyValueList;

public class JsonKvlMapper {
    public static KeyValueList parse(String json) throws JsonMappingException, JsonProcessingException {
        JsonKvlMapper m = new JsonKvlMapper();
        KeyValueList kvl = m._parse(json);
        return kvl;
    }

    public KeyValueList _parse(String json) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        JsonNode jn = om.readTree(json);
        return this.createKvl(jn);
    }

    protected KeyValueList createKvl(JsonNode jn) {
        KeyValueList kvl = new KeyValueList();
        Iterator it = jn.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            JsonNode sub = jn.get(fieldName);
            if (sub.isArray()) {
                this.fillList(sub, kvl.createList(fieldName));
                continue;
            }
            if (sub.isObject()) {
                KeyValueList subl = this.createKvl(sub);
                kvl.setObject(fieldName, subl);
                continue;
            }
            kvl.setValue(fieldName, sub.asText());
        }
        return kvl;
    }

    protected void fillList(JsonNode jn, List<KeyValueList> kvlList) {
        int x = 0;
        while (x < jn.size()) {
            JsonNode n = jn.get(x);
            if (n.isObject()) {
                kvlList.add(this.createKvl(n));
            } else {
                System.out.println("Skipping...");
            }
            ++x;
        }
    }

    public static void main(String[] args) {
        String data = "{\"data\":{\"id\":\"3f2cf3c6-3891-0892-8e58-a7352dc68c55\",\"account\":{\"type\":\"account\",\"id\":\"064b9b8f-28a9-0dc7-815f-2de710b36be4\"},\"first_name\":\"Tim\",\"last_name\":\"van Weezenbeek\",\"email\":\"tim@itxplain.nl\",\"email_verification_status\":\"confirmed\",\"language\":\"nl-NL\",\"telephones\":[{\"type\":\"mobile\",\"number\":\"625327459\"}],\"function\":null,\"time_zone\":\"Europe/Amsterdam\",\"avatar_url\":null,\"preferences\":{\"invoiceable\":true,\"historic_time_tracking_limit\":null,\"whitelabeling\":true}}}\n";
        try {
            JsonKvlMapper mapper = new JsonKvlMapper();
            KeyValueList kvl = JsonKvlMapper.parse(data);
            System.out.println("firstname: " + kvl.getObject("data").getValue("last_name"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

