/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jtbcore.util.BooleanUtil;
import jtbcore.util.DateUtil;
import jtbcore.util.MapUtil;
import jtbcore.util.NumberUtil;

public class KeyValueList {
    protected Map<String, String> keyValues = new LinkedHashMap<String, String>();
    protected Map<String, List<KeyValueList>> lists = new LinkedHashMap<String, List<KeyValueList>>();
    protected Map<String, List<String>> arrayList = new LinkedHashMap<String, List<String>>();
    protected Map<String, KeyValueList> objects = new LinkedHashMap<String, KeyValueList>();

    public Map<String, String> getKeyValueMap() {
        return this.keyValues;
    }

    public void setValue(String key, String val) {
        this.keyValues.put(key, val);
    }

    public boolean hasValue(String key) {
        return this.keyValues.containsKey(key);
    }

    public String getValue(String key) {
        return this.keyValues.get(key);
    }

    public String getValueTrim(String key) {
        String s = this.keyValues.get(key);
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public Integer getValueInt(String key) {
        return NumberUtil.tryParseInt(this.keyValues.get(key));
    }

    public Long getValueLong(String key) {
        return NumberUtil.tryParseLong(this.keyValues.get(key));
    }

    public Double getValueDouble(String key) {
        return NumberUtil.tryParseDouble(this.keyValues.get(key));
    }

    public boolean getValueBool(String key) {
        return BooleanUtil.isTrue(this.keyValues.get(key));
    }

    public Date getValueDate(String key) {
        return DateUtil.string2date(this.keyValues.get(key));
    }

    public Date getValueDateTime(String key) {
        return DateUtil.string2datetime(this.keyValues.get(key));
    }

    public Double getDoubleCurrency(String key) {
        return NumberUtil.tryCurrencyToDouble(this.keyValues.get(key));
    }

    public KeyValueList createObject(String name) {
        KeyValueList kvl = new KeyValueList();
        this.objects.put(name, kvl);
        return kvl;
    }

    public void setObject(String name, KeyValueList kvl) {
        this.objects.put(name, kvl);
    }

    public KeyValueList getObject(String name) {
        if (this.objects.containsKey(name)) {
            return this.objects.get(name);
        }
        return this.createObject(name);
    }

    public boolean hasObject(String name) {
        return this.objects.containsKey(name);
    }

    public boolean hasObjects() {
        return this.objects.size() > 0;
    }

    public List<KeyValueList> createList(String name) {
        ArrayList<KeyValueList> l = new ArrayList<KeyValueList>();
        this.lists.put(name, l);
        return l;
    }

    public List<String> getArrayList(String name) {
        if (!this.arrayList.containsKey(name)) {
            this.arrayList.put(name, new ArrayList());
        }
        return this.arrayList.get(name);
    }

    public List<Integer> getArrayListInt(String name) {
        if (!this.arrayList.containsKey(name)) {
            this.arrayList.put(name, new ArrayList());
        }
        List<String> l = this.getArrayList(name);
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (String i : l) {
            Integer j = NumberUtil.tryParseInt(i);
            if (j == null) continue;
            r.add(j);
        }
        return r;
    }

    public Map<String, List<String>> getArrayLists() {
        return this.arrayList;
    }

    public List<KeyValueList> getList(String name) {
        if (!this.lists.containsKey(name)) {
            return this.createList(name);
        }
        return this.lists.get(name);
    }

    public boolean hasList(String name) {
        return this.lists.containsKey(name);
    }

    public boolean hasLists() {
        return this.lists.size() > 0;
    }

    public Map<String, Object> flatList() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (String k : this.keyValues.keySet()) {
            m.put(k, this.keyValues.get(k));
        }
        for (String k : this.arrayList.keySet()) {
            List<String> strs = this.arrayList.get(k);
            int x = 0;
            while (x < strs.size()) {
                m.put(k + "." + x, strs.get(x));
                ++x;
            }
        }
        Map<String, Object> sub = this.flatSubList();
        MapUtil.merge(sub, m);
        return m;
    }

    public Map<String, Object> flatSubList() {
        Map<String, Object> subm;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        Iterator<String> iterator = this.lists.keySet().iterator();
        while (iterator.hasNext()) {
            String listName;
            String n = listName = iterator.next();
            subm = this._flatSubList(n, this.lists.get(listName));
            MapUtil.merge(subm, m);
        }
        for (String k : this.objects.keySet()) {
            KeyValueList o = this.objects.get(k);
            subm = this._flatSubList(k, o);
            MapUtil.merge(subm, m);
        }
        return m;
    }

    protected Map<String, Object> _flatSubList(String prefix, Object listOrMap) {
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
        if (listOrMap instanceof KeyValueList) {
            Map<String, Object> subm;
            KeyValueList kvl = (KeyValueList)listOrMap;
            for (String k : kvl.getKeyValueMap().keySet()) {
                subm = this._flatSubList((String)prefix + "." + k, kvl.getValue(k));
                MapUtil.merge(subm, r);
            }
            for (String k : kvl.objects.keySet()) {
                subm = this._flatSubList((String)prefix + "." + k, kvl.getObject(k));
                MapUtil.merge(subm, r);
            }
            for (String k : kvl.lists.keySet()) {
                subm = this._flatSubList((String)prefix + "." + k, kvl.getList(k));
                MapUtil.merge(subm, r);
            }
            for (String k : kvl.arrayList.keySet()) {
                List<String> strs = kvl.arrayList.get(k);
                int x = 0;
                while (x < strs.size()) {
                    r.put((String)prefix + "." + k + "." + x, strs.get(x));
                    ++x;
                }
            }
        } else if (listOrMap instanceof Map) {
            if (((String)prefix).length() > 0) {
                prefix = (String)prefix + ".";
            }
            Map m = (Map)listOrMap;
            for (String k : m.keySet()) {
                Map<String, Object> subm;
                Object o = m.get(k);
                if (o == null) {
                    r.put((String)prefix + k, o);
                    continue;
                }
                if (o instanceof Map) {
                    subm = this._flatSubList((String)prefix + k, o);
                    MapUtil.merge(subm, r);
                    continue;
                }
                if (!(o instanceof List)) continue;
                subm = this._flatSubList((String)prefix + k, o);
                MapUtil.merge(subm, r);
            }
        } else if (listOrMap instanceof List) {
            List l = (List)listOrMap;
            int x = 0;
            while (x < l.size()) {
                Map<String, Object> subm = this._flatSubList((String)prefix + "." + x, l.get(x));
                MapUtil.merge(subm, r);
                ++x;
            }
        } else {
            r.put((String)prefix, listOrMap);
        }
        return r;
    }

    protected void loadNodes(JsonNode jn) {
        Iterator names = jn.fieldNames();
        while (names.hasNext()) {
            String n = (String)names.next();
            JsonNode sub = jn.get(n);
            if (sub.size() > 0) {
                if (sub.isArray() && !sub.fieldNames().hasNext()) {
                    int x;
                    List<Object> l;
                    if (sub.size() > 0 && sub.get(0).isObject()) {
                        l = this.getList(n);
                        x = 0;
                        while (x < sub.size()) {
                            KeyValueList submodel = new KeyValueList();
                            submodel.loadNodes(sub.get(x));
                            l.add(submodel);
                            ++x;
                        }
                        continue;
                    }
                    l = this.getArrayList(n);
                    x = 0;
                    while (x < sub.size()) {
                        l.add(sub.get(x).asText());
                        ++x;
                    }
                    continue;
                }
                KeyValueList submodel = new KeyValueList();
                submodel.loadNodes(sub);
                if (jn.isObject()) {
                    this.setObject(n, submodel);
                    continue;
                }
                this.getList(n).add(submodel);
                continue;
            }
            this.setValue(n, sub.asText());
        }
    }

    public static KeyValueList fromJson(InputStream is) throws IOException {
        ObjectMapper om = new ObjectMapper();
        JsonNode jn = om.readTree(is);
        KeyValueList m = new KeyValueList();
        m.loadNodes(jn);
        return m;
    }

    public static KeyValueList fromJson(String s) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        JsonNode jn = om.readTree(s);
        KeyValueList m = new KeyValueList();
        m.loadNodes(jn);
        return m;
    }

    public static void main(String[] args) {
        String j = "{\"a\":\"save\",\"customer\":{\"addresses\":[],\"phones\":[],\"emails\":[{\"email_id\":null,\"emailAddress\":\"timbo@itxplain.nl\",\"description\":\"\"}],\"customerId\":\"1\",\"customerType\":\"personal\",\"customerName\":\"Timmah\",\"contactPerson\":\"\",\"iban\":\"\",\"bic\":\"\",\"edited\":1710429041452,\"created\":1710428686453}}\n";
        try {
            KeyValueList kvl = KeyValueList.fromJson(j);
            KeyValueList c = kvl.getObject("customer");
            System.out.println("Test: " + c.getList("emails").get(0).getValue("emailAddress"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

