/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model;

import jtbcore.exception.InvalidStateException;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class HourModel {
    protected Integer hour = 0;
    protected Integer minute = 0;

    public HourModel() {
    }

    public HourModel(String time) throws InvalidStateException {
        this.setTime(time);
    }

    public void setTime(String t) throws InvalidStateException {
        if (!DateUtil.validTime(t)) {
            throw new InvalidStateException("Invalid time-format");
        }
        String[] toks = t.split(":");
        this.hour = NumberUtil.tryParseInt(toks[0]);
        this.minute = NumberUtil.tryParseInt(toks[1]);
    }

    public Integer getHour() {
        return this.hour;
    }

    public void setHour(Integer hour) throws InvalidStateException {
        if (hour == null || hour < 0 || hour > 23) {
            throw new InvalidStateException("Invalid hour");
        }
        this.hour = hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public void setMinute(Integer minute) throws InvalidStateException {
        if (minute == null || minute < 0 || minute > 59) {
            throw new InvalidStateException("Invalid minute");
        }
        this.minute = minute;
    }
}

