/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.sqlite;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.db.sqlite.SqliteTableModelGenerator;
import jtbcore.exception.InvalidStateException;

public class SqlLiteConnection
extends SqlConnection {
    protected String path = null;
    protected SqlDatabase sqlDb = null;

    public SqlLiteConnection() {
        this.START_VAL = (char)34;
        this.STOP_VAL = (char)34;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void connect() throws SQLException, InvalidStateException {
        if (this.path == null || this.path.trim().length() == 0) {
            throw new InvalidStateException("Sqlite path not set");
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.path);
    }

    @Override
    public void initModel(DatabaseModel model) throws SQLException, IOException {
        SqliteTableModelGenerator modgen = new SqliteTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0) {
            this.sqlDb = null;
        }
    }

    @Override
    public void updateTable(TableModel t) throws SQLException, IOException {
        DatabaseModel model = new DatabaseModel();
        t.setAutogenerated(true);
        model.addTable(t);
        SqliteTableModelGenerator modgen = new SqliteTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0 && this.sqlDb != null) {
            for (TableModel tm : updatedTables) {
                SqlTable qt = modgen.buildSqlTable(this, tm.getName());
                this.sqlDb.addTable(qt);
            }
        }
    }

    @Override
    public void resetSqlDatabase() {
        this.sqlDb = null;
    }

    @Override
    public void truncateTable(String tblname) throws SQLException {
        this.query("delete from `" + tblname + "`", new Object[0]);
        this.query("update SQLITE_SEQUENCE SET SEQ=1 WHERE NAME = ?", tblname);
    }

    @Override
    public SqlDatabase getSqlDatabase() throws IOException, SQLException {
        if (this.sqlDb == null) {
            SqliteTableModelGenerator gen = new SqliteTableModelGenerator();
            this.sqlDb = gen.sqliteToSqlDatabase(this);
        }
        return this.sqlDb;
    }

    @Override
    public Integer insertQuery(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = super._insertQuery(sql, args);
        ps.close();
        return this.queryInteger("select last_insert_rowid()", new Object[0]);
    }

    public static void main(String[] args) {
        try {
            SqlLiteConnection c = new SqlLiteConnection();
            c.setPath("/home/timvw/mydb.sqlite");
            c.connect();
            c.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

