/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jtbcore.db.sql.SqlColumn;

public class SqlTable {
    protected char START_VAL = (char)48;
    protected char STOP_VAL = (char)48;
    protected String name;
    protected String schemaName;
    protected Map<String, SqlColumn> columns;
    protected List<SqlColumn> listColumns;

    public SqlTable(String name) {
        this.setName(name);
        this.columns = new ConcurrentHashMap<String, SqlColumn>();
        this.listColumns = new ArrayList<SqlColumn>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableRef() {
        if (this.START_VAL != '0') {
            if (this.schemaName != null) {
                return this.START_VAL + this.schemaName + this.STOP_VAL + "." + this.START_VAL + this.name + this.STOP_VAL;
            }
            return this.START_VAL + this.name + this.STOP_VAL;
        }
        if (this.schemaName != null) {
            return this.schemaName + "." + this.name;
        }
        return this.name;
    }

    public void setStartTopVal(char startVal, char stopVal) {
        this.START_VAL = startVal;
        this.STOP_VAL = stopVal;
    }

    public List<SqlColumn> getColumns() {
        return this.listColumns;
    }

    public SqlColumn getColumnByName(String n) {
        return this.columns.get(n.toLowerCase());
    }

    public void setColumn(SqlColumn col) {
        int x = this.listColumns.size() - 1;
        while (x >= 0) {
            if (this.listColumns.get((int)0).name.equalsIgnoreCase(col.name)) {
                this.listColumns.remove(x);
            }
            --x;
        }
        this.columns.put(col.name.toLowerCase(), col);
        this.listColumns.add(col);
    }

    public void setColumns(List<SqlColumn> columns) {
        this.columns = new ConcurrentHashMap<String, SqlColumn>();
        this.listColumns = columns;
        for (SqlColumn c : columns) {
            this.columns.put(c.name.toLowerCase(), c);
        }
    }

    public SqlColumn getColumn(String n) {
        return this.columns.get(n.toLowerCase());
    }

    public boolean hasColumn(String n) {
        return this.columns.containsKey(n.toLowerCase());
    }
}

