/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.mssql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.mssql.MSSqlTableModelGenerator;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.AppLogger;

public class MSSqlConnection
extends SqlConnection {
    protected Boolean integratedSecurity;
    protected String host;
    protected String username;
    protected String password;
    protected String databaseName;
    protected SqlDatabase sqlDb = null;

    public MSSqlConnection() {
        this.START_VAL = (char)91;
        this.STOP_VAL = (char)93;
    }

    public Boolean getIntegratedSecurity() {
        return this.integratedSecurity;
    }

    public void setIntegratedSecurity(Boolean integratedSecurity) {
        this.integratedSecurity = integratedSecurity;
    }

    public String getHost() {
        if (this.host == null || this.host.trim().length() == 0) {
            return "localhost";
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public void connect() throws SQLException, InvalidStateException {
        Connection con = null;
        Object url = "jdbc:sqlserver://";
        url = this.host == null || this.host.trim().length() == 0 || ".".equals(this.host) ? (String)url + "localhost" : (String)url + this.host;
        url = (String)url + ";databaseName=" + this.databaseName;
        url = (String)url + ";trustServerCertificate=true;loginTimeout=5";
        if (this.integratedSecurity.booleanValue()) {
            url = (String)url + ";integratedSecurity=true";
            AppLogger.log("mssql con url: " + (String)url);
            con = DriverManager.getConnection((String)url);
        } else {
            System.out.println("mssql con url: " + (String)url);
            con = DriverManager.getConnection((String)url, this.username, this.password);
        }
        this.connection = con;
    }

    @Override
    public void updateTable(TableModel t) throws SQLException, IOException {
        DatabaseModel model = new DatabaseModel();
        t.setAutogenerated(true);
        model.addTable(t);
        MSSqlTableModelGenerator modgen = new MSSqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0 && this.sqlDb != null) {
            for (TableModel tm : updatedTables) {
                SqlTable qt = modgen.buildSqlTable(this, null, tm.getName());
                this.sqlDb.addTable(qt);
            }
        }
    }

    @Override
    public SqlDatabase getSqlDatabase() throws IOException, SQLException {
        if (this.sqlDb == null) {
            MSSqlTableModelGenerator gen = new MSSqlTableModelGenerator();
            this.sqlDb = gen.mssqlToSqlDatabase(this);
        }
        return this.sqlDb;
    }

    @Override
    public void resetSqlDatabase() {
        this.sqlDb = null;
    }

    @Override
    public Integer insertQuery(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = super._insertQuery(sql, args);
        ps.close();
        return this.queryInteger("select @@IDENTITY", new Object[0]);
    }

    @Override
    public void initModel(DatabaseModel model) throws SQLException, IOException {
        MSSqlTableModelGenerator modgen = new MSSqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0) {
            this.sqlDb = null;
        }
    }

    public void test() throws SQLException {
        Connection con;
        this.connection = con = DriverManager.getConnection("jdbc:sqlserver://localhost;databaseName=dumptest;trustServerCertificate=true;socketTimeout=5;loginTimeout=5;integratedSecurity=true");
    }

    public static void main(String[] args) {
        try {
            System.out.println("Test: " + System.getProperty("java.library.path"));
            MSSqlConnection c = new MSSqlConnection();
            System.out.println("Test()..");
            c.test();
            System.out.println("queryList()..");
            List bsms = c.queryList("select * from [master].[dbo].[spt_monitor]", new Object[0]);
            for (BaseStringMap m : bsms) {
                System.out.println("Test: " + m.getProperty("lastrun"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

