/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jtbcore.db.model.ColumnModel;
import jtbcore.db.model.IndexModel;
import jtbcore.exception.InvalidStateException;
import jtbcore.util.NumberUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableModel {
    protected String name;
    protected String schemaName;
    protected boolean autogenerated = true;
    protected Map<String, String> meta = new ConcurrentHashMap<String, String>();
    protected Map<String, ColumnModel> columns = new ConcurrentHashMap<String, ColumnModel>();
    protected List<ColumnModel> listColumns = new ArrayList<ColumnModel>();
    protected Map<String, IndexModel> indexes = new ConcurrentHashMap<String, IndexModel>();
    protected List<IndexModel> listIndexes = new ArrayList<IndexModel>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String sn) {
        this.schemaName = sn;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    public String getMeta(String key) {
        return this.meta.get(key);
    }

    public void setMeta(String key, String val) {
        this.meta.put(key, val);
    }

    public ColumnModel getPrimaryKey() {
        for (ColumnModel cm : this.getColumns()) {
            if (!cm.isPrimaryKey()) continue;
            return cm;
        }
        return null;
    }

    public void loadNodes(Node nodeTable) throws InvalidStateException {
        Node n;
        Node autogen;
        String tableName = nodeTable.getAttributes().getNamedItem("name").getNodeValue();
        this.setName(tableName);
        Node nSchemaName = nodeTable.getAttributes().getNamedItem("schemaName");
        if (nSchemaName != null) {
            this.setSchemaName(nSchemaName.getNodeValue());
        }
        if ((autogen = nodeTable.getAttributes().getNamedItem("autogenerate")) != null && ("0".equals(autogen.getNodeValue()) || "false".equalsIgnoreCase(autogen.getNodeValue()))) {
            this.setAutogenerated(false);
        }
        NodeList nlChilds = nodeTable.getChildNodes();
        int x = 0;
        while (x < nlChilds.getLength()) {
            n = nlChilds.item(x);
            if ("meta".equals(n.getNodeName())) {
                NodeList props = n.getChildNodes();
                int y = 0;
                while (y < props.getLength()) {
                    NamedNodeMap attrs;
                    Node nname;
                    if ("property".equals(props.item(y).getNodeName()) && (nname = (attrs = props.item(y).getAttributes()).getNamedItem("name")) != null && nname.getNodeValue() != null && nname.getNodeValue().trim().length() != 0) {
                        Node nval = attrs.getNamedItem("value");
                        String name = nname.getNodeValue().trim();
                        String value = "";
                        if (nval != null && nval.getNodeValue() != null) {
                            value = nval.getNodeValue().trim();
                        }
                        this.meta.put(name, value);
                    }
                    ++y;
                }
            }
            ++x;
        }
        x = 0;
        while (x < nlChilds.getLength()) {
            n = nlChilds.item(x);
            if ("column".equals(n.getNodeName())) {
                ColumnModel cm = new ColumnModel();
                cm.loadNode(n);
                this.columns.put(cm.getName(), cm);
                this.listColumns.add(cm);
            }
            ++x;
        }
        x = 0;
        while (x < nlChilds.getLength()) {
            n = nlChilds.item(x);
            if ("index".equals(n.getNodeName())) {
                IndexModel im = new IndexModel();
                im.loadNode(n);
                this.indexes.put(im.getName(), im);
                this.listIndexes.add(im);
            }
            ++x;
        }
    }

    public List<ColumnModel> getColumns() {
        return this.listColumns;
    }

    public boolean hasColumn(String name) {
        return this.getColumn(name) != null;
    }

    public ColumnModel getColumn(String name) {
        for (ColumnModel cm : this.listColumns) {
            if (!name.equals(cm.getName())) continue;
            return cm;
        }
        return null;
    }

    public boolean hasIndexes() {
        return this.indexes.size() > 0;
    }

    public List<IndexModel> getIndexes() {
        return this.listIndexes;
    }

    public static void main(String[] args) {
        try {
            String type = "varchar ( 50 ) ";
            String len = type.replaceAll("varchar\\s*\\(.*?(\\d+).*", "$1");
            Integer maxLen = NumberUtil.tryParseInt(len);
            System.out.println("maxlen: " + String.valueOf(maxLen));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

