/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.common;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jtbcore.db.common.SqlConnection;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;

public class QueryBuilder {
    protected SqlConnection sqlConnection;
    protected boolean distinct = false;
    protected List<SqlField> fields = new ArrayList<SqlField>();
    protected String table;
    protected List<JoinTable> joinTables = new ArrayList<JoinTable>();
    protected List<WhereClause> wheres = new ArrayList<WhereClause>();
    protected String whereJoin = "AND";
    protected String orderBy = null;
    protected String groupBy = null;
    protected String having = null;
    protected int offset = -1;
    protected int limit = -1;
    List<Object> qParams;
    StringBuilder qBuf;

    public QueryBuilder(SqlConnection con) {
        this.sqlConnection = con;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getRawOrderBy() {
        return this.orderBy;
    }

    public void setRawOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getHaving() {
        return this.having;
    }

    public void setHaving(String having) {
        this.having = having;
    }

    public void setWhereJoin(String j) throws InvalidStateException {
        if (!"AND".equalsIgnoreCase(j) && !"OR".equalsIgnoreCase(j)) {
            throw new InvalidStateException("Invalid join-token: " + j);
        }
        this.whereJoin = j.toUpperCase();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void addFunctionField(String function, String label) {
        FunctionField ff = new FunctionField(function, label);
        this.fields.add(ff);
    }

    public void addSelectField(String ref, String fieldName, String label) {
        SelectField f = new SelectField(ref, fieldName, label);
        this.fields.add(f);
    }

    public void addSelectField(String ref, String fieldName) {
        SelectField f = new SelectField(ref, fieldName);
        this.fields.add(f);
    }

    public void addSelectField(String fieldName) {
        SelectField f = new SelectField(fieldName);
        this.fields.add(f);
    }

    public void addJoin(String table, String onClause, String label) {
        JoinTable jt = new JoinTable(table, onClause, label);
        jt.joinType = null;
        this.joinTables.add(jt);
    }

    public void addLeftJoin(String table, String onClause) {
        this.addLeftJoin(table, onClause, null);
    }

    public void addLeftJoin(String table, String onClause, String label) {
        JoinTable jt = new JoinTable(table, onClause, label);
        jt.joinType = "LEFT";
        this.joinTables.add(jt);
    }

    public void addRightJoin(String table, String onClause, String label) {
        JoinTable jt = new JoinTable(table, onClause, label);
        jt.joinType = "RIGHT";
        this.joinTables.add(jt);
    }

    public void addWhere(String sql, Object ... params) {
        WhereClause wc = new WhereClause(sql, params);
        this.wheres.add(wc);
    }

    public void addWhere(WhereClause wc) {
        this.wheres.add(wc);
    }

    protected void buildQuery() {
        this.qParams = new ArrayList<Object>();
        this.qBuf = new StringBuilder();
    }

    protected void buildSelect() {
        this.qBuf.append("SELECT ");
        if (this.distinct) {
            this.qBuf.append(" DISTINCT ");
        }
        int x = 0;
        while (x < this.fields.size()) {
            this.qBuf.append("\n\t\t");
            if (x > 0) {
                this.qBuf.append(", ");
            }
            this.qBuf.append(this.fields.get(x).toString());
            ++x;
        }
        this.qBuf.append("\n");
    }

    protected void buildFrom() {
        this.qBuf.append("FROM ").append(this.getTable()).append("\n");
    }

    protected void buildJoin() {
        int x = 0;
        while (x < this.joinTables.size()) {
            this.qBuf.append(this.joinTables.get(x).toString()).append("\n");
            ++x;
        }
    }

    protected void buildWhere() {
        if (this.wheres.size() > 0) {
            StringBuilder sbWhere = new StringBuilder();
            int x = 0;
            while (x < this.wheres.size()) {
                WhereClause wc = this.wheres.get(x);
                if (wc.hasClauses()) {
                    if (sbWhere.length() > 0) {
                        sbWhere.append("\t").append(this.whereJoin);
                    }
                    sbWhere.append("\t\t").append(wc.getSql()).append("\n");
                    Object[] objectArray = wc.getSqlParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        this.qParams.add(o);
                        ++n2;
                    }
                }
                ++x;
            }
            if (sbWhere.length() > 0) {
                this.qBuf.append(" WHERE\n");
                this.qBuf.append(sbWhere.toString());
            }
        }
    }

    protected void buildGroupBy() {
        if (this.groupBy != null) {
            this.qBuf.append(" GROUP BY " + this.groupBy + "\n");
            if (this.having != null) {
                this.qBuf.append(" HAVING " + this.having + "\n");
            }
        }
    }

    protected void buildOffsetOrder() {
        if (this.orderBy != null) {
            this.qBuf.append("ORDER BY ").append(this.orderBy).append("\n");
        }
        if (this.offset != -1 || this.limit != -1) {
            if (this.offset != -1 && this.limit != -1) {
                this.qBuf.append("LIMIT " + this.limit + " OFFSET " + this.offset).append("\n");
            } else if (this.limit != -1) {
                this.qBuf.append("LIMIT " + this.limit).append("\n");
            }
        }
    }

    public Integer queryCount() throws SQLException, InvalidStateException {
        this.buildQuery();
        this.qBuf.append("SELECT COUNT(*) ");
        this.buildFrom();
        this.buildJoin();
        this.buildWhere();
        if (this.groupBy != null) {
            throw new InvalidStateException("groupBy set, queryCount not working");
        }
        String sql = this.qBuf.toString();
        Integer i = this.sqlConnection.queryInteger(sql, this.qParams.toArray());
        return i;
    }

    public ResultSet queryResultSet() throws SQLException {
        this.buildQuery();
        this.buildSelect();
        this.buildFrom();
        this.buildJoin();
        this.buildWhere();
        this.buildGroupBy();
        this.buildOffsetOrder();
        String sql = this.qBuf.toString();
        try {
            return this.sqlConnection.queryResultSet(sql, this.qParams.toArray());
        }
        catch (Exception ex) {
            System.out.println("SQL: " + sql);
            throw ex;
        }
    }

    public List toList(Class clazz) throws SQLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<BaseStringMapObject> l = new ArrayList<BaseStringMapObject>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet rs = this.queryResultSet();){
            while (rs.next()) {
                BaseStringMap rec = SqlConnection.resultSet2StringMap(rs);
                BaseStringMapObject o = (BaseStringMapObject)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                o.setBaseStringMap(rec);
                l.add(o);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return l;
    }

    public class FunctionField
    implements SqlField {
        public String function = null;
        public String label = null;

        public FunctionField(String function) {
            this.function = function;
        }

        public FunctionField(String function, String label) {
            this.function = function;
            this.label = label;
        }

        public String toString() {
            Object s = this.function;
            if (this.label != null) {
                s = (String)s + " AS " + this.label;
            }
            return s;
        }
    }

    public class JoinTable {
        public String joinType = "LEFT";
        public String refTable = null;
        public String onClause = null;
        public String label = null;

        public JoinTable(String refTable, String onClause) {
            this.refTable = refTable;
            this.onClause = onClause;
        }

        public JoinTable(String joinType, String refTable, String onClause, String label) {
            this.joinType = joinType;
            this.refTable = refTable;
            this.onClause = onClause;
            this.label = label;
        }

        public JoinTable(String refTable, String onClause, String label) {
            this.refTable = refTable;
            this.onClause = onClause;
            this.label = label;
        }

        public String toString() {
            Object s = "";
            if (this.joinType != null) {
                s = (String)s + this.joinType + " ";
            }
            s = (String)s + "JOIN " + this.refTable;
            if (this.label != null) {
                s = (String)s + " AS " + QueryBuilder.this.sqlConnection.getStartVal() + this.label + QueryBuilder.this.sqlConnection.getStopVal();
            }
            s = (String)s + " ON (" + this.onClause + ")";
            return s;
        }
    }

    public class SelectField
    implements SqlField {
        public String fieldRef = null;
        public String fieldName = null;
        public String label = null;

        public SelectField(String fieldName) {
            this.fieldName = fieldName;
        }

        public SelectField(String fieldRef, String fieldName) {
            this.fieldRef = fieldRef;
            this.fieldName = fieldName;
        }

        public SelectField(String fieldRef, String fieldName, String label) {
            this.fieldRef = fieldRef;
            this.fieldName = fieldName;
            this.label = label;
        }

        public String toString() {
            Object s = "";
            if (this.fieldRef != null) {
                s = (String)s + QueryBuilder.this.sqlConnection.getStartVal() + this.fieldRef + QueryBuilder.this.sqlConnection.getStopVal() + ".";
            }
            s = (String)s + QueryBuilder.this.sqlConnection.getStartVal() + this.fieldName + QueryBuilder.this.sqlConnection.getStopVal();
            if (this.label != null) {
                s = (String)s + " AS " + QueryBuilder.this.sqlConnection.getStartVal() + this.label + QueryBuilder.this.sqlConnection.getStopVal();
            }
            return s;
        }
    }

    public static interface SqlField {
    }

    public static class WhereClause {
        public List<WhereClause> subClauses = new ArrayList<WhereClause>();
        public String joinMethod = "AND";
        public String where = null;
        public Object[] params = null;

        public WhereClause(String where) {
            this.where = where;
        }

        public WhereClause(String where, Object[] params) {
            this.where = where;
            this.params = params;
        }

        public boolean hasClauses() {
            return this.where != null || this.subClauses.size() > 0;
        }

        public void addWhere(String sql, Object ... params) {
            WhereClause wc = new WhereClause(sql, params);
            this.subClauses.add(wc);
        }

        public String getSql() {
            if (this.subClauses.size() > 0) {
                StringBuilder b = new StringBuilder();
                if (this.where != null) {
                    b.append("(").append(this.where).append(")");
                }
                int x = 0;
                while (x < this.subClauses.size()) {
                    if (b.length() > 0) {
                        b.append(" ").append(this.joinMethod).append(" ");
                    }
                    b.append(this.subClauses.get(x).getSql());
                    ++x;
                }
                return b.toString();
            }
            return " (" + this.where + ") ";
        }

        public Object[] getSqlParams() {
            if (this.subClauses.size() > 0) {
                ArrayList<Object> lp = new ArrayList<Object>();
                if (this.params != null && this.params.length > 0) {
                    Object[] objectArray = this.params;
                    int n = this.params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object p = objectArray[n2];
                        lp.add(p);
                        ++n2;
                    }
                }
                int x = 0;
                while (x < this.subClauses.size()) {
                    Object[] subp = this.subClauses.get(x).getSqlParams();
                    int y = 0;
                    while (y < subp.length) {
                        lp.add(subp[y]);
                        ++y;
                    }
                    ++x;
                }
                return lp.toArray();
            }
            if (this.params == null) {
                return new Object[0];
            }
            return this.params;
        }
    }
}

