/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.app;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.mysql.MysqlConnection;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sqlite.SqlLiteConnection;
import jtbcore.exception.UnsupportedException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.appconfig.GroupSetting;
import jtbcore.util.BooleanUtil;
import jtbcore.util.NumberUtil;

public abstract class DbAppConfig {
    protected String databaseFile;
    protected SqlConnection connection = null;

    public abstract Integer getAppVersion();

    public static InputStream getResourceAsInput(String p) {
        InputStream is = DbAppConfig.class.getResourceAsStream(p);
        if (is == null) {
            is = p.startsWith("/") ? DbAppConfig.class.getResourceAsStream("/src" + p) : DbAppConfig.class.getResourceAsStream("/src/" + p);
        }
        return is;
    }

    public abstract String getAppName();

    public String getLicenseCode() throws SQLException {
        return this.getProperty("appLicenseCode");
    }

    public void setLicenseCode(String c) throws SQLException, IOException {
        this.setProperty("appLicenseCode", c != null ? c.trim() : "");
    }

    public void setConnection(SqlConnection con) throws Exception {
        this.connection = con;
        this.initTables();
    }

    public SqlConnection getConnection() {
        return this.connection;
    }

    public void open() throws Exception {
        if (this.connection == null || this.connection instanceof SqlLiteConnection) {
            if (this.connection == null) {
                this.connection = new SqlLiteConnection();
            }
            ((SqlLiteConnection)this.connection).setPath(this.databaseFile);
            this.connection.connect();
        }
        this.initTables();
    }

    public String getDatabaseFile() {
        return this.databaseFile;
    }

    public void setDatabaseFile(String databaseFile) {
        this.databaseFile = databaseFile;
    }

    protected void initTables() throws Exception {
        if (this.connection instanceof SqlLiteConnection) {
            this.initTablesSqlite();
        } else if (this.connection instanceof MysqlConnection) {
            this.initTablesMysql();
        } else {
            throw new UnsupportedException("Database type not supported");
        }
    }

    protected void initTablesMysql() throws Exception {
        String sqlSettings;
        boolean updated = false;
        SqlDatabase sqldb = this.connection.getSqlDatabase();
        if (!sqldb.hasTable("setting")) {
            sqlSettings = "create table setting (\n\tid integer primary key auto_increment,\n\t`key` varchar(128),\n\tvalue text,\n\tunique uc_key (`key`)\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
            updated = true;
        }
        if (!sqldb.hasTable("group_setting")) {
            sqlSettings = "create table group_setting (\n\tid integer primary key auto_increment,\n\tcode text,\n\tdescription text,\n\tsort integer\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
            updated = true;
        }
        if (!sqldb.hasTable("group_setting_value")) {
            sqlSettings = "create table group_setting_value (\n\tid integer primary key auto_increment,\n\tgroup_setting_id integer,\n\t`key` varchar(128),\n\tvalue text,\n\tunique uc_key (group_setting_id, `key`)\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
            updated = true;
        }
        this.connection.resetSqlDatabase();
    }

    protected void initTablesSqlite() throws Exception {
        String sqlSettings;
        Map<String, BaseStringMap> records = this.connection.queryMap("tbl_name", "select * from sqlite_master", new Object[0]);
        if (!records.containsKey("setting")) {
            sqlSettings = "create table setting (\n\tid integer primary key autoincrement,\n\tkey text,\n\tvalue text,\n\tconstraint uc_key unique (key)\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
        }
        if (!records.containsKey("group_setting")) {
            sqlSettings = "create table group_setting (\n\tid integer primary key autoincrement,\n\tcode text,\n\tdescription text,\n\tsort integer\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
        }
        if (!records.containsKey("group_setting_value")) {
            sqlSettings = "create table group_setting_value (\n\tid integer primary key autoincrement,\n\tgroup_setting_id integer,\n\tkey text,\n\tvalue text,\n\tconstraint uc_key unique (group_setting_id, key)\n)\n";
            this.connection.query(sqlSettings, new Object[0]);
        }
    }

    public void setProperty(String k, String v) throws SQLException, IOException {
        BaseStringMap m = new BaseStringMap();
        m.setProperty("key", k);
        m.setProperty("value", v);
        Integer id = this.connection.queryInteger("select id from setting where " + this.connection.encloseCol("key") + " = ?", k);
        if (id == null) {
            this.connection.insertRecord("setting", m);
        } else {
            this.connection.updateRecord("setting", "id=" + String.valueOf(id), m);
        }
    }

    public void setProperty(String k, Double d) throws SQLException, IOException {
        if (d != null) {
            this.setProperty(k, Double.toString(d));
        }
    }

    public Double getPropertyDouble(String k) throws SQLException, IOException {
        String v = this.getProperty(k);
        return NumberUtil.tryParseDouble(v);
    }

    public Long getPropertyLong(String k) throws SQLException, IOException {
        String v = this.getProperty(k);
        return NumberUtil.tryParseLong(v);
    }

    public void setProperty(String k, Integer d) throws SQLException, IOException {
        if (d != null) {
            this.setProperty(k, Integer.toString(d));
        }
    }

    public Integer getPropertyInt(String k) throws SQLException, IOException {
        String v = this.getProperty(k);
        return NumberUtil.tryParseInt(v);
    }

    public String getProperty(String k) throws SQLException {
        Object o = this.connection.queryValue("select value from setting where " + this.connection.encloseCol("key") + " = ?", String.class, k);
        return (String)o;
    }

    public void setProperty(String k, Boolean b) throws SQLException, IOException {
        if (b == null) {
            b = false;
        }
        this.setProperty(k, b != false ? "1" : "0");
    }

    public Boolean getPropertyBoolean(String k, Boolean defaultVal) throws SQLException {
        String o = (String)this.connection.queryValue("select value from setting where " + this.connection.encloseCol("key") + " = ?", String.class, k);
        if (o == null) {
            return defaultVal;
        }
        if (BooleanUtil.isTrue(o).booleanValue()) {
            return true;
        }
        if (BooleanUtil.isFalse(o).booleanValue()) {
            return false;
        }
        return defaultVal;
    }

    public String getAppUid() throws SQLException, IOException {
        String appuid = this.getProperty("appuid");
        if (appuid == null) {
            appuid = UUID.randomUUID().toString();
            this.setProperty("appuid", appuid);
        }
        return appuid;
    }

    public Long getAppInitTime() throws SQLException, IOException {
        if (this.getProperty("appInitTime") == null) {
            this.setProperty("appInitTime", Long.toString(System.currentTimeMillis()));
        }
        return NumberUtil.tryParseLong(this.getProperty("appInitTime"));
    }

    public List<GroupSetting> getGroups(String groupCode) throws SQLException {
        ArrayList<GroupSetting> r = new ArrayList<GroupSetting>();
        List l = this.connection.queryList("select * from group_setting where code = ? order by sort, id", groupCode);
        for (BaseStringMap gs : l) {
            GroupSetting g = new GroupSetting();
            g.setId(gs.getPropertyInt("id"));
            g.setCode(gs.getProperty("code"));
            g.setDescription(gs.getProperty("description"));
            g.setSort(gs.getPropertyInt("sort"));
            List vals = this.connection.queryList("select * from group_setting_value where group_setting_id = ?", g.getId());
            g.setValues(vals);
            r.add(g);
        }
        return r;
    }

    public Integer addGroup(String groupCode) throws SQLException {
        return this.addGroup(groupCode, null, null);
    }

    public Integer addGroup(String groupCode, String description, Integer sort) throws SQLException {
        Integer id = this.connection.insertQuery("insert into group_setting (code, description, sort) values (?, ?, ?)", groupCode, description, sort);
        return id;
    }

    public void saveGroup(GroupSetting g, List<BaseStringMap> values) throws IOException, SQLException {
        BaseStringMap m = new BaseStringMap();
        if (g.getId() != null) {
            m.setProperty("id", g.getId());
        }
        m.setProperty("code", g.getCode());
        m.setProperty("description", g.getDescription());
        m.setProperty("sort", g.getSort());
        if (g.getId() == null) {
            Integer id = this.connection.insertRecord("group_setting", m);
            g.setId(id);
        } else {
            this.connection.updateRecord("group_setting", "id=" + String.valueOf(g.getId()), m);
        }
        if (values != null) {
            int x = 0;
            while (x < values.size()) {
                BaseStringMap bsm = values.get(x);
                bsm.setProperty("group_setting_id", g.getId());
                String key = bsm.getProperty("key");
                Integer gsId = (Integer)this.connection.queryValue("select id from group_setting_value where group_setting_id = ? and " + this.connection.encloseCol("key") + " = ?", Integer.class, g.getId(), key);
                if (gsId == null) {
                    this.connection.insertRecord("group_setting_value", bsm);
                } else {
                    this.connection.updateRecord("group_setting_value", "id=" + String.valueOf(gsId), bsm);
                }
                ++x;
            }
        }
    }

    public void saveGroup(GroupSetting g) throws IOException, SQLException {
        ArrayList<BaseStringMap> l = new ArrayList<BaseStringMap>(g.getValues().values());
        this.saveGroup(g, l);
        System.out.println("saveGroup");
    }

    public void setGroupProperty(Integer groupId, String key, Integer val) throws SQLException {
        String v = val != null ? val.toString() : "";
        this.setGroupProperty(groupId, key, v);
    }

    public void setGroupProperty(Integer groupId, String key, String val) throws SQLException {
        Integer id = this.connection.queryInteger("select id from group_setting_value where group_setting_id = ? and " + this.connection.encloseCol("key") + " = ?", groupId, key);
        if (id == null) {
            this.connection.insertQuery("insert into group_setting_value (group_setting_id, " + this.connection.encloseCol("key") + ", value) values (?, ?, ?)", groupId, key, val);
        } else {
            this.connection.query("update group_setting_value set group_setting_id=?, " + this.connection.encloseCol("key") + "=?, value=? where id = ?", groupId, key, val, id);
        }
    }

    public void deleteGroup(GroupSetting sg) throws SQLException {
        this.connection.query("delete from group_setting_value where group_setting_id = ?", sg.getId());
        this.connection.query("delete from group_setting where id = ?", sg.getId());
    }

    public void deleteGroup(Integer settingGroupId) throws SQLException {
        this.connection.query("delete from group_setting_value where group_setting_id = ?", settingGroupId);
        this.connection.query("delete from group_setting where id = ?", settingGroupId);
    }

    public void deleteGroupValues(Integer settingGroupId) throws SQLException {
        this.connection.query("delete from group_setting_value where group_setting_id = ?", settingGroupId);
    }

    public List<BaseStringMap> getGroupValues(Integer settingGroupId) throws SQLException {
        List<BaseStringMap> l = this.connection.queryBsmList("select * from group_setting_value where group_setting_id = ?", settingGroupId);
        return l;
    }

    public static void main(String[] args) {
    }
}

