/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jtbcore.model.BaseStringMap;
import jtbcore.util.NumberUtil;

public class BaseAppConfig {
    protected Properties props = new Properties();

    public void setProperty(String key, String val) {
        this.props.setProperty(key, val);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.props.containsKey(key)) {
            return this.props.getProperty(key);
        }
        return defaultValue;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public boolean save(String f) {
        try {
            File file = new File(f);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));
            this.props.store(fos, "");
            ((OutputStream)fos).close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean load(String f) {
        try {
            File file = new File(f);
            if (file.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                this.props.load(is);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void setGroupProperty(String groupName, int groupNo, String key, String val) {
        this.props.setProperty(groupName + "." + groupNo + "." + key, val);
    }

    public void setGroupProperties(String groupName, List<Map<String, String>> list) {
        this.deleteGroup(groupName);
        int groupNo = 0;
        for (Map<String, String> m : list) {
            for (String key : m.keySet()) {
                this.setGroupProperty(groupName, groupNo, key, m.get(key));
            }
            ++groupNo;
        }
    }

    public void setGroupPropertiesStringMap(String groupName, List<BaseStringMap> list) {
        this.deleteGroup(groupName);
        int groupNo = 0;
        for (BaseStringMap m : list) {
            for (String key : m.getMap().keySet()) {
                this.setGroupProperty(groupName, groupNo, key, m.getProperty(key));
            }
            ++groupNo;
        }
    }

    public void insertGroup(String groupName, Map<String, String> list) {
        Integer no = this.nextGroupNo(groupName);
        for (String k : list.keySet()) {
            this.setGroupProperty(groupName, no, k, list.get(k));
        }
    }

    public List<Map<String, String>> getGroupProperties(String groupName) {
        ArrayList<Integer> groupNumbers = new ArrayList<Integer>();
        for (Object key : this.props.keySet()) {
            Integer no;
            String groupNo;
            if (key.toString().indexOf(groupName + ".") != 0 || (groupNo = key.toString().substring(groupName.length() + 1)).indexOf(".") <= 0 || !(groupNo = groupNo.substring(0, groupNo.indexOf("."))).matches("^[0-9]+$") || (no = NumberUtil.tryParseInt(groupNo)) == null || groupNumbers.contains(no)) continue;
            groupNumbers.add(no);
        }
        groupNumbers.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Integer groupNo : groupNumbers) {
            HashMap<String, String> rec = new HashMap<String, String>();
            String keyPrefix = groupName + "." + String.valueOf(groupNo) + ".";
            for (Object key : this.props.keySet()) {
                if (key.toString().indexOf(keyPrefix) != 0) continue;
                String k = key.toString().substring(keyPrefix.length());
                rec.put(k, this.props.getProperty((String)key));
            }
            result.add(rec);
        }
        return result;
    }

    public Integer nextGroupNo(String groupName) {
        Integer groupNo = 0;
        for (Object k : this.props.keySet()) {
            Integer no;
            String part;
            if (k.toString().indexOf(groupName + ".") != 0 || (part = k.toString().substring(groupName.length() + 1)).indexOf(".") <= 0 || (no = NumberUtil.tryParseInt(part = part.substring(0, part.indexOf(".")))) == null || no <= groupNo) continue;
            groupNo = no + 1;
        }
        return groupNo;
    }

    public String getGroupProperty(String groupName, int groupNo, String key) {
        return this.getProperty(groupName + "." + groupNo + "." + key);
    }

    public void deleteGroup(String groupName) {
        Set<Object> keys = this.props.keySet();
        for (Object key : keys) {
            if (key.toString().indexOf(groupName + ".") != 0) continue;
            this.props.remove(key);
        }
    }

    public void deleteGroup(String groupName, Integer groupNo) {
        Set<Object> keys = this.props.keySet();
        for (Object key : keys) {
            if (key.toString().indexOf(groupName + "." + String.valueOf(groupNo) + ".") != 0) continue;
            this.props.remove(key);
        }
    }

    public static void main(String[] args) {
        try {
            BaseAppConfig c = new BaseAppConfig();
            c.load("C:/tmp/myapp.properties3");
            List<Map<String, String>> l = c.getGroupProperties("mylist");
            for (Map<String, String> rec : l) {
                System.out.println("rec: " + String.valueOf(rec));
            }
            Properties props = System.getProperties();
            for (Object k : props.keySet()) {
                System.out.println(String.valueOf(k) + "\t" + props.getProperty((String)k));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

