/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.service;

import itx.erp.exception.ObjectNotFoundException;
import itx.erp.webmail.model.EmailTemplate;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import jtbcore.db.common.QueryBuilder;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.service.ServiceBase;

public class EmailTemplateService
extends ServiceBase {
    public List<EmailTemplate> listTemplates() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.addSelectField("email_template_id");
        qb.addSelectField("template_code");
        qb.addSelectField("name");
        qb.addSelectField("from_name");
        qb.addSelectField("from_email");
        qb.addSelectField("subject");
        qb.addSelectField("sort");
        qb.addSelectField("active");
        qb.addSelectField("edited");
        qb.addSelectField("created");
        qb.setTable("webmail__email_template");
        qb.setRawOrderBy("sort asc");
        return qb.toList(EmailTemplate.class);
    }

    public EmailTemplate readTemplate(Integer emailTemplateId) throws SQLException, JTBException {
        EmailTemplate t = (EmailTemplate)this.queryToObject(EmailTemplate.class, "select * from webmail__email_template where email_template_id = ?", emailTemplateId);
        if (t == null) {
            throw new ObjectNotFoundException("EmailTemplate not found");
        }
        return t;
    }

    public EmailTemplate readByCode(String emailTemplateCode) throws SQLException, JTBException {
        Integer id = (Integer)this.connection.queryValue("select email_template_id from webmail__email_template where template_code = ?", Integer.class, emailTemplateCode);
        if (emailTemplateCode == null) {
            throw new ObjectNotFoundException("EmailTemplate code not found");
        }
        return this.readTemplate(id);
    }

    public EmailTemplate save(EmailTemplate t) throws SQLException, JTBException, IOException {
        EmailTemplate prev;
        if (t.getEmailTemplateId() == null && t.getTemplateCode() != null && t.getTemplateCode().length() > 0 && (prev = (EmailTemplate)this.queryToObject(EmailTemplate.class, "select * from webmail__email_template where template_code = ?", t.getTemplateCode())) != null && !prev.getEmailTemplateId().equals(t.getEmailTemplateId())) {
            throw new InvalidStateException("Already exists a template with code " + t.getTemplateCode());
        }
        EmailTemplate new_et = null;
        EmailTemplate old_et = null;
        if (t.getEmailTemplateId() == null) {
            new_et = t;
        } else {
            new_et = this.readTemplate(t.getEmailTemplateId());
            old_et = this.readTemplate(t.getEmailTemplateId());
        }
        new_et.setFromName(t.getFromName());
        new_et.setFromEmail(t.getFromEmail());
        new_et.setSubject(t.getSubject());
        new_et.setContent(t.getContent());
        this.connection.save("webmail__email_template", "email_template_id", new_et);
        return new_et;
    }
}

