/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.webmail.model.EmailTemplate;
import itx.erp.webmail.service.EmailTemplateService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;

public class EmailTemplateController
extends BaseController {
    protected EmailTemplateService emailTemplateService;

    public EmailTemplateService getEmailTemplateService() {
        return this.emailTemplateService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void listAction(WebRequest req) throws Exception {
        List<EmailTemplate> ets = this.emailTemplateService.listTemplates();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("templates", ets);
        req.renderJson(r);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer etid = req.getParamInt("id");
        EmailTemplate t = this.emailTemplateService.readTemplate(etid);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("emailTemplate", t);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        KeyValueList kvlt = req.getKvl().getObject("template");
        EmailTemplate t = new EmailTemplate();
        t.setEmailTemplateId(kvlt.getValueInt("emailTemplateId"));
        t.setFromName(kvlt.getValue("fromName"));
        t.setFromEmail(kvlt.getValue("fromEmail"));
        t.setSubject(kvlt.getValue("subject"));
        t.setContent(kvlt.getValue("content"));
        t = this.emailTemplateService.save(t);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("emailTemplate", t);
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) {
    }
}

