/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.webmail.conf.EmailSettings;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.service.EmailService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.validator.EmailValidator;

public class EmailSettingsController
extends BaseController {
    protected EmailSettings emailSettings;
    protected EmailService emailService;

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("emailSettings", this.emailSettings);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, IOException {
        this.emailSettings.setFromName(req.getParameter("fromName"));
        this.emailSettings.setFromEmail(req.getParameter("fromEmail"));
        this.emailSettings.setSendMethod(req.getParameter("sendMethod"));
        this.emailSettings.setSmtpHost(req.getParameter("smtpHost"));
        this.emailSettings.setSmtpPort(req.getParamInt("smtpPort"));
        this.emailSettings.setSmtpTls(req.getParamBool("smtpTls"));
        this.emailSettings.setSmtpUsername(req.getParameter("smtpUsername"));
        if (req.notEmpty("smtpPassword")) {
            this.emailSettings.setSmtpPassword(req.getParameter("smtpPassword"));
        }
        this.emailSettings.save();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void testMailAction(WebRequest req) throws Exception {
        EmailSettings s = new EmailSettings();
        s.setFromName(req.getParameter("fromName"));
        s.setFromEmail(req.getParameter("fromEmail"));
        s.setSendMethod(req.getParameter("sendMethod"));
        s.setSmtpHost(req.getParameter("smtpHost"));
        s.setSmtpPort(req.getParamInt("smtpPort"));
        s.setSmtpTls(req.getParamBool("smtpTls"));
        s.setSmtpUsername(req.getParameter("smtpUsername"));
        if (req.notEmpty("smtpPassword")) {
            s.setSmtpPassword(req.getParameter("smtpPassword"));
        } else {
            s.setSmtpPassword(this.emailSettings.getSmtpPassword());
        }
        EmailMessage m = new EmailMessage();
        m.setFromName(s.getFromName());
        if (EmailValidator.getInstance().isValid(s.getFromEmail())) {
            m.setFromEmail(s.getFromEmail());
        }
        m.addTo(req.getParameter("emailAddress"), null);
        m.setSubject("Test mail");
        m.setTextContent("<body>Dit is een test mail</body>");
        this.emailService.sendMail(m, s);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

