/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.helper.ErpConfig;
import itx.erp.webmail.conf.EmailSettings;
import itx.erp.webmail.model.EmailFile;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.model.EmailSearchResult;
import itx.erp.webmail.model.EmailTo;
import itx.erp.webmail.service.EmailService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.FileException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.FileUtil;

public class EmailMessageController
extends BaseController {
    protected ErpConfig appConfig;
    protected EmailSettings emailSettings;
    protected EmailService emailService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public ErpObjectContainer getObjectContainer() {
        return ErpObjectContainer.getInstance();
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("result", true);
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws Exception {
        this.checkAdmin(req);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("emailSettings", this.emailSettings);
        result.put("result", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        this.checkAdmin(req);
        Integer emid = req.getParamInt("emailMessageId");
        EmailMessage m = this.emailService.readEmail(emid);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("emailMessage", m);
        result.put("result", true);
        req.renderJson(result);
    }

    public void deleteFileAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        this.checkAdmin(req);
        Integer fid = req.getParamInt("fileId");
        this.emailService.deleteFile(fid);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("result", true);
        req.renderJson(result);
    }

    public void downloadFileAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        this.checkAdmin(req);
        Integer fid = req.getParamInt("id");
        EmailFile ef = this.emailService.readFile(fid);
        File path = new File(this.getObjectContainer().getDataDir() + "/" + ef.getPath());
        HttpServletResponse response = req.getResponse();
        System.out.println("filename: " + ef.getFilename());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + ef.getFilename() + "\"");
        ServletOutputStream os = req.getResponse().getOutputStream();
        FileUtil.file2outputstream(path, (OutputStream)os);
        os.close();
    }

    public void saveAction(WebRequest req) throws Exception {
        this.checkAdmin(req);
        Integer emid = req.getParamInt("emailMessageId");
        EmailMessage m = emid != null ? this.emailService.readEmail(emid) : new EmailMessage();
        KeyValueList kvl = KeyValueList.fromJson(req.getParameter("data"));
        m.setCustomerId(kvl.getValueInt("customerId"));
        m.setSubject(kvl.getValue("subject"));
        m.setTextContent(kvl.getValue("textContent"));
        m.getTos().clear();
        List<KeyValueList> kvlTos = kvl.getList("tos");
        int x = 0;
        while (x < kvlTos.size()) {
            EmailTo et = new EmailTo();
            et.setToType(kvlTos.get(x).getValue("type"));
            et.setToName(kvlTos.get(x).getValue("name"));
            et.setToEmail(kvlTos.get(x).getValue("email"));
            if (et.hasToEmail().booleanValue()) {
                m.getTos().add(et);
            }
            ++x;
        }
        this.emailService.saveEmail(m);
        Part p = req.getRequest().getPart("file");
        if (p != null) {
            EmailFile f = new EmailFile();
            f.setFilename(p.getSubmittedFileName());
            this.emailService.saveFile(f);
            File filesDir = new File(this.getObjectContainer().getDataDir() + "/email/files");
            if (!filesDir.exists() && !filesDir.mkdirs()) {
                throw new FileException("Unable to create email files dir");
            }
            String path = "/email/files/" + String.valueOf(f.getEmailFileId()) + "-" + f.getFilename();
            InputStream is = p.getInputStream();
            FileUtil.inputStream2File(is, this.getObjectContainer().getDataDir() + path);
            is.close();
            f.setPath(path);
            f.setEmailMessageId(m.getEmailMessageId());
            this.emailService.saveFile(f);
        }
        boolean sent = false;
        if (req.getParamBool("sendMail").booleanValue()) {
            EmailMessage msg = this.emailService.readEmail(emid);
            this.emailService.sendMail(msg);
            sent = true;
        }
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("emailMessageId", m.getEmailMessageId());
        result.put("success", Boolean.valueOf(true));
        result.put("sent", Boolean.valueOf(sent));
        req.renderJson(result);
    }

    public void deleteMailAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        this.checkAdmin(req);
        Integer emailId = req.getParamInt("emailId");
        this.emailService.deleteEmail(emailId);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void searchAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        this.checkAdmin(req);
        Integer start = req.getParamInt("start", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", 50);
        opts.put("q", req.getParameter("q"));
        QueryResult<EmailSearchResult> qr = this.emailService.searchEmail(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("emails", qr.getObjects());
        result.put("start", qr.getStart());
        result.put("pageSize", qr.getPageSize());
        result.put("rowCount", qr.getRowCount());
        req.renderJson(result);
    }
}

