/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.conf;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import itx.erp.ErpObjectContainer;
import itx.erp.helper.ErpConfig;
import itx.erp.webmail.model.EmailTemplate;
import itx.erp.webmail.service.EmailTemplateService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

@JsonIgnoreProperties(value={"appConfig", "smtpPassword"})
public class EmailSettings {
    protected ErpConfig appConfig;
    protected Map<String, Object> settings = new ConcurrentHashMap<String, Object>();

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public void load() throws SQLException {
        this.settings.put("email_fromName", this.appConfig.getSetting("email_fromName", ""));
        this.settings.put("email_fromEmail", this.appConfig.getSetting("email_fromEmail", ""));
        this.settings.put("email_smtpHost", this.appConfig.getSetting("email_smtpHost", ""));
        this.settings.put("email_smtpPort", this.appConfig.getSettingInt("email_smtpPort", 587));
        this.settings.put("email_smtpTls", this.appConfig.getSettingInt("email_smtpTls", 0));
        this.settings.put("email_smtpUsername", this.appConfig.getSetting("email_smtpUsername", ""));
        this.settings.put("email_smtpPassword", this.appConfig.getSetting("email_smtpPassword", ""));
        this.initBaseTemplates();
    }

    public void save() throws SQLException, IOException {
        this.appConfig.setSetting("email_fromName", this.getFromName());
        this.appConfig.setSetting("email_fromEmail", this.getFromEmail());
        this.appConfig.setSetting("email_smtpHost", this.getSmtpHost());
        this.appConfig.setSetting("email_smtpPort", this.getSmtpPort());
        this.appConfig.setSetting("email_smtpTls", this.getSmtpTls() != false ? 1 : 0);
        this.appConfig.setSetting("email_smtpUsername", this.getSmtpUsername());
        this.appConfig.setSetting("email_smtpPassword", this.getSmtpPassword());
    }

    public String getFromName() throws SQLException {
        String n = (String)this.settings.get("email_fromName");
        if (n != null && n.trim().length() > 0) {
            return n;
        }
        return "Toolbox";
    }

    public void setFromName(String m) {
        this.settings.put("email_fromName", m);
    }

    public String getFromEmail() {
        String e = (String)this.settings.get("email_fromEmail");
        if (e != null && e.trim().length() > 0) {
            return e;
        }
        return "info@localhost";
    }

    public void setFromEmail(String m) {
        this.settings.put("email_fromEmail", m);
    }

    public String getSendMethod() {
        String s = (String)this.settings.get("email_sendMethod");
        if ("smtp".equals(s) || "r2bmailserver".equals(s)) {
            return s;
        }
        return "r2bmailserver";
    }

    public void setSendMethod(String m) {
        this.settings.put("email_sendMethod", m);
    }

    public String getSmtpHost() {
        return (String)this.settings.get("email_smtpHost");
    }

    public void setSmtpHost(String m) {
        this.settings.put("email_smtpHost", m);
    }

    public Integer getSmtpPort() {
        Object p = this.settings.get("email_smtpPort");
        if (p instanceof Integer) {
            return (Integer)p;
        }
        if (p == null) {
            return 25;
        }
        return NumberUtil.tryParseInt(p.toString());
    }

    public void setSmtpPort(Integer m) throws SQLException, IOException {
        if (m == null) {
            this.settings.put("email_smtpPort", "");
        } else {
            this.settings.put("email_smtpPort", m);
        }
    }

    public Boolean getSmtpTls() throws SQLException {
        Integer i = (Integer)this.settings.get("email_smtpTls");
        if (i != null && i != 0) {
            return true;
        }
        return false;
    }

    public void setSmtpTls(Boolean b) {
        this.settings.put("email_smtpTls", b != false ? 1 : 0);
    }

    public String getSmtpUsername() {
        return (String)this.settings.get("email_smtpUsername");
    }

    public void setSmtpUsername(String m) {
        this.settings.put("email_smtpUsername", m);
    }

    public String getSmtpPassword() {
        return (String)this.settings.get("email_smtpPassword");
    }

    public void setSmtpPassword(String m) {
        this.settings.put("email_smtpPassword", m);
    }

    public boolean getSmtpPasswordSet() {
        return StringUtil.notEmpty(this.getSmtpPassword());
    }

    public boolean hasAuthentication() throws SQLException {
        return this.getSmtpUsername() != null && this.getSmtpUsername().trim().length() > 0;
    }

    private void initBaseTemplates() {
        try {
            this.initTemplateResetPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initTemplateResetPassword() throws SQLException, JTBException, IOException {
        ErpObjectContainer oc = ErpObjectContainer.getInstance();
        EmailTemplateService etService = (EmailTemplateService)oc.getBean("emailTemplateService");
        if (etService == null) {
            return;
        }
        Integer c1 = (Integer)etService.getConnection().queryValue("select count(*) from webmail__email_template where template_code = ?", Integer.class, "RESET_PASSWORD");
        if (c1 > 0) {
            return;
        }
        String tpl = "<div>\n\tBeste heer/mevrouw,\n\t<br/>\n\t<br/>Er is zojuist een wachtwoord reset aangevraagd voor uw account.\n\t<br/>\n\t<br/>Klik <a href=\"[[link]]\">hier</a> om een nieuw wachtwoord in te stellen.\n\t<br/>\n\t<br/>Met vriendelijke groet,\n\t<br/>Report2base.nl\n</div>\n";
        EmailTemplate t = new EmailTemplate();
        t.setTemplateCode("RESET_PASSWORD");
        t.setName("Wachtwoord resetten");
        t.setSubject("Wachtwoord resetten Report2base");
        t.setFromName("Report2base.nl");
        t.setFromEmail("noreply@report2base.nl");
        t.setContent(tpl);
        t.setActive(true);
        etService.save(t);
    }
}

