/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.service;

import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.exception.ObjectNotFoundException;
import itx.erp.sales.model.Offer;
import itx.erp.sales.model.OfferLine;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class OfferService
extends ServiceBase {
    protected CustomerService customerService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public List<String> listOfferStatus() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("open");
        l.add("sent");
        l.add("accepted");
        l.add("rejected");
        l.add("partial");
        l.add("cancelled");
        return l;
    }

    public QueryResult<Offer> searchOffers(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("sales__offer");
        b.addSelectField("sales__offer", "offer_id");
        b.addSelectField("sales__offer", "customer_id");
        b.addSelectField("sales__offer", "offer_date");
        b.addSelectField("sales__offer", "offer_status");
        b.addSelectField("sales__offer", "offer_number");
        b.addSelectField("sales__offer", "subject");
        b.addSelectField("sales__offer", "total_calculated_price");
        b.addSelectField("sales__offer", "total_calculated_price_incl_vat");
        b.addSelectField("sales__offer", "deposit");
        b.addSelectField("sales__offer", "payment_upfront");
        b.addSelectField("sales__offer", "edited");
        b.addSelectField("sales__offer", "created");
        b.addSelectField("customer__customer", "customer_name");
        b.addLeftJoin("customer__customer", "customer__customer.customer_id = sales__offer.customer_id");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere(" customer__customer.customer_name like ? or sales__offer.offer_number like ? or sales__offer.subject like ?", "%" + q + "%", "%" + q, "%" + q + "%");
        }
        b.setRawOrderBy("offer_number desc");
        ResultSet rs = b.queryResultSet();
        QueryResult<Offer> qr = new QueryResult<Offer>();
        if (opts.containsKey("start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (opts.containsKey("pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(Offer.class, rs);
        rs.close();
        return qr;
    }

    public Offer readOffer(Integer offerId) throws SQLException, JTBException {
        Offer o = (Offer)this.queryToObject(Offer.class, "select * from sales__offer where offer_id = ?", offerId);
        if (o == null) {
            throw new ObjectNotFoundException("Offer not found");
        }
        List l = this.queryToList(OfferLine.class, "select * from sales__offer_line where offer_id = ? order by sort", offerId);
        o.setLines(l);
        if (o.getCustomerId() != null) {
            Customer cust = this.customerService.readCustomer(o.getCustomerId());
            o.setCustomer(cust);
        }
        return o;
    }

    public Integer saveOffer(Offer offer) throws IOException, SQLException, JTBException {
        Offer oldOffer = null;
        if (offer.getOfferId() != null) {
            oldOffer = this.readOffer(offer.getOfferId());
        }
        if (offer.getOfferNumber() == null) {
            Integer newOfferNo = (Integer)this.connection.queryValue("select max(offer_number) from sales__offer", Integer.class, new Object[0]);
            newOfferNo = newOfferNo == null || newOfferNo == 0 ? 1000 : newOfferNo + 1;
            offer.setOfferNumber(newOfferNo);
        }
        long totalExclVat = 0L;
        long totalInclVat = 0L;
        for (OfferLine ol : offer.getLines()) {
            if ("text".equals(ol.getLineType())) continue;
            Double et = 0.0;
            if (ol.getAmount() != null && ol.getPriceExclVat() != null) {
                et = ol.getAmount() * ol.getPriceExclVat() * 100.0;
            }
            totalExclVat += (long)et.intValue();
            Double it = 0.0;
            if (ol.getAmount() != null && ol.getPriceInclVat() != null) {
                it = ol.getAmount() * ol.getPriceInclVat() * 100.0;
            }
            totalInclVat += (long)it.intValue();
        }
        offer.setTotalCalculatedPrice((double)totalExclVat / 100.0);
        offer.setTotalCalculatedPriceInclVat((double)totalInclVat / 100.0);
        Integer offerId = this.connection.save("sales__offer", "offer_id", offer.getBaseStringMap());
        offer.setOfferId(offerId);
        List<OfferLine> lines = offer.getLines();
        int x = 0;
        while (x < lines.size()) {
            Integer oldLineId = null;
            if (oldOffer != null && x < oldOffer.getLines().size()) {
                oldLineId = oldOffer.getLines().get(x).getOfferLineId();
            }
            OfferLine newLine = lines.get(x);
            newLine.setOfferLineId(oldLineId);
            newLine.setOfferId(offerId);
            this.connection.save("sales__offer_line", "offer_line_id", newLine.getBaseStringMap());
            ++x;
        }
        if (oldOffer != null) {
            while (x < oldOffer.getLines().size()) {
                Integer olid = oldOffer.getLines().get(x).getOfferLineId();
                this.connection.query("delete from sales__offer_line where offer_line_id = ?", olid);
                ++x;
            }
        }
        return offerId;
    }

    public void deleteOffer(Integer offerId) throws IOException, SQLException, JTBException {
        Offer offer = this.readOffer(offerId);
        this.connection.query("delete from sales__offer_line where offer_id = ?", offerId);
        this.connection.query("delete from sales__offer where offer_id = ?", offerId);
    }
}

