/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.service;

import itx.erp.exception.ObjectNotFoundException;
import itx.erp.sales.rental.model.Dayprice;
import itx.erp.sales.rental.model.DaypriceEntry;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class RentalDaypriceService
extends ServiceBase {
    public Dayprice readDayprice(Integer id) throws SQLException, JTBException {
        Dayprice p = (Dayprice)this.queryToObject(Dayprice.class, "select * from rental__dayprice where dayprice_id = ?", id);
        if (p == null) {
            throw new ObjectNotFoundException("Dayprice not found");
        }
        List entries = this.queryToList(DaypriceEntry.class, "select * from rental__dayprice_entry where dayprice_id = ? order by sort", id);
        p.setEntries(entries);
        return p;
    }

    public void save(Dayprice p) throws IOException, SQLException {
        this.connection.save("rental__dayprice", "dayprice_id", p);
        this.connection.saveOTM("rental__dayprice_entry", "dayprice_id", p.getDaypriceId(), p.getEntries());
    }

    public void delete(Dayprice p) throws SQLException {
        this.connection.query("delete from rental__dayprice where dayprice_id = ?", p.getDaypriceId());
        this.connection.query("delete from rental__dayprice_entry where dayprice_id = ?", p.getDaypriceId());
    }

    public void deleteDayprice(Integer daypriceId) throws SQLException, JTBException {
        Dayprice p = this.readDayprice(daypriceId);
        this.delete(p);
    }

    public QueryResult<Dayprice> searchDayprice(Map<String, Object> opts) throws SQLException, JTBException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("rental__dayprice");
        b.addSelectField("rental__dayprice", "dayprice_id");
        b.addSelectField("rental__dayprice", "name");
        b.addSelectField("rental__dayprice", "edited");
        b.addSelectField("rental__dayprice", "created");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere("name like ? ", "%" + q + "%");
        }
        b.setRawOrderBy("sort");
        ResultSet rs = b.queryResultSet();
        QueryResult qr = QueryResult.build(Dayprice.class, opts, rs);
        rs.close();
        return qr;
    }

    public List<Dayprice> readAllDayprices() throws SQLException, JTBException {
        List l = this.queryToList(Dayprice.class, "select * from rental__dayprice order by sort", new Object[0]);
        return l;
    }
}

