/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.Slotplan;
import itx.erp.sales.model.Vat;
import itx.erp.sales.rental.model.Dayprice;
import itx.erp.sales.rental.model.RentalContract;
import itx.erp.sales.rental.model.RentalContractLine;
import itx.erp.sales.rental.model.response.RentalContractLineResponse;
import itx.erp.sales.rental.model.response.RentalContractResponse;
import itx.erp.sales.rental.model.validator.RentalContractValidator;
import itx.erp.sales.rental.service.RentalDaypriceService;
import itx.erp.sales.rental.service.RentalService;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.SlotService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class RentalController
extends BaseController {
    protected ErpConfig appConfig;
    protected CustomerService customerService;
    protected RentalService rentalService;
    protected SalesSettings salesSettings;
    protected ArticleService articleService;
    protected SlotService slotService;
    protected RentalDaypriceService rentalDaypriceService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public RentalService getRentalService() {
        return this.rentalService;
    }

    public void setRentalService(RentalService rentalService) {
        this.rentalService = rentalService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    public RentalDaypriceService getRentalDaypriceService() {
        return this.rentalDaypriceService;
    }

    public void setRentalDaypriceService(RentalDaypriceService rentalDaypriceService) {
        this.rentalDaypriceService = rentalDaypriceService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    protected RentalContract buildRentalContract(WebRequest req) throws SQLException, JTBException {
        Integer customerId = req.getParamInt("customerId");
        RentalContract contract = new RentalContract();
        contract.setCustomerId(customerId);
        contract.setDescription("Contract");
        List<KeyValueList> lines = req.getKvl().getList("lines");
        for (KeyValueList kvl : lines) {
            Double vatAmount;
            Double a;
            KeyValueList kvlarticle = kvl.getObject("article");
            Integer articleId = kvlarticle.getValueInt("articleId");
            RentalContractLine l = new RentalContractLine();
            Article art = null;
            if (articleId != null) {
                art = this.getArticleService().readArticle(articleId);
            }
            if (art != null && art.isRentable().booleanValue()) {
                l.setLineType("rental");
                if ("hour".equals(art.getPricingMethod()) || "slotplan".equals(art.getPricingMethod())) {
                    l.setRentalType("hour");
                } else {
                    l.setRentalType("day");
                }
            } else if ("price".equals(kvlarticle.getValue("lineType"))) {
                l.setLineType("price");
            } else {
                l.setLineType("article");
            }
            Vat vat = null;
            if (art != null) {
                l.setDescription(art.getShortDescription());
                vat = art.getVat();
            } else {
                Integer vatId = kvl.getValueInt("vatId");
                vat = this.articleService.readVat(vatId);
                l.setDescription(kvl.getValue("description"));
            }
            l.getBaseStringMap().setProperty("originalDescription", l.getDescription());
            if ("createOffer".equals(req.getParameter("a")) && kvlarticle.hasValue("shortDescription")) {
                l.setDescription(kvlarticle.getValue("shortDescription"));
            }
            if ((a = kvl.getValueDouble("amount")) == null) {
                a = 1.0;
            }
            l.setAmount(a);
            String price = kvl.getValue("price");
            Double p = NumberUtil.tryCurrencyToDouble(price);
            if (p == null) {
                p = 0.0;
            }
            if (this.salesSettings.inputPriceExclVat()) {
                vatAmount = 0.0;
                if (vat != null) {
                    vatAmount = p * vat.getPercentage() / (100.0 + vat.getPercentage());
                    vatAmount = NumberUtil.roundPrice(vatAmount);
                }
                l.setPriceExclVat(p);
                l.setPriceInclVat(NumberUtil.roundPrice(p + vatAmount));
            }
            if (this.salesSettings.inputPriceInclVat()) {
                vatAmount = 0.0;
                if (vat != null) {
                    vatAmount = p * vat.getPercentage() / 100.0;
                    vatAmount = NumberUtil.roundPrice(vatAmount);
                }
                l.setPriceExclVat(NumberUtil.roundPrice(p - vatAmount));
                l.setPriceInclVat(p);
            }
            l.setArticleId(articleId);
            l.setVatId(vat.getVatId());
            if (art != null && art.isRentable().booleanValue()) {
                String startDate = kvlarticle.getValue("startDate");
                String endDate = kvlarticle.getValue("endDate");
                if (startDate == null) {
                    startDate = DateUtil.nowDate();
                }
                l.setStartTime(startDate);
                l.setEndTime(endDate);
                l.setTimeNotice(kvlarticle.getValueInt("timeNotice"));
                l.setRenewalPeriod(kvlarticle.getValueInt("renewalPeriod"));
                if ("week".equals(art.getPricingMethod())) {
                    l.setTimeNoticeUnit("week");
                    l.setRenewalType("week");
                }
                if ("month".equals(art.getPricingMethod())) {
                    l.setTimeNoticeUnit("month");
                    l.setRenewalType("month");
                }
            }
            contract.getLines().add(l);
        }
        return contract;
    }

    public void createContractAction(WebRequest req) throws SQLException, JTBException, IOException {
        RentalContractValidator v = new RentalContractValidator();
        RentalContract contract = this.buildRentalContract(req);
        if (!v.validate(contract)) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("success", false);
            r.put("error", true);
            r.put("errors", v.getErrors());
            req.renderJson(r);
            return;
        }
        this.getRentalService().save(contract);
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("rentalContractId", contract.getRentalContractId());
        req.renderJson(r);
    }

    public void createOfferAction(WebRequest req) throws SQLException, JTBException, IOException {
        RentalContractValidator v = new RentalContractValidator();
        RentalContract contract = this.buildRentalContract(req);
        if (!v.validate(contract)) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("success", false);
            r.put("error", true);
            r.put("errors", v.getErrors());
            req.renderJson(r);
            return;
        }
        Integer offerId = this.getRentalService().createOffer(contract);
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("rentalContractId", contract.getRentalContractId());
        r.put("offerId", offerId);
        req.renderJson(r);
    }

    public void searchContractsAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<RentalContractResponse> rcs = this.rentalService.searchContract(opts);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("contracts", rcs.getObjects());
        r.put("start", rcs.getStart());
        r.put("pageSize", rcs.getPageSize());
        r.put("rowCount", rcs.getRowCount());
        req.renderJson(r);
    }

    public void readContractAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer rentalContractId = req.getParamInt("rentalContractId");
        RentalContract rc = this.rentalService.readContract(rentalContractId);
        Customer c = this.customerService.readCustomer(rc.getCustomerId());
        List<RentalContractLineResponse> lines = null;
        if (c != null) {
            lines = this.rentalService.linesByCustomer(c.getCustomerId());
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("lines", lines);
        r.put("customer", c);
        r.put("contract", rc);
        r.put("salesSettings", this.getSalesSettings());
        req.renderJson(r);
    }

    public void saveContractAction(WebRequest req) throws SQLException, JTBException, IOException {
        KeyValueList kvcontract = req.getKvl().getObject("contract");
        Integer rentalContractId = kvcontract.getValueInt("rentalContractId");
        RentalContract rc = this.getRentalService().readContract(rentalContractId);
        rc.setDescription(kvcontract.getValue("description"));
        rc.setActive(kvcontract.getValueBool("active"));
        ArrayList<RentalContractLine> lines = new ArrayList<RentalContractLine>();
        List<KeyValueList> kvllines = kvcontract.getList("lines");
        int x = 0;
        while (x < kvllines.size()) {
            Double price;
            KeyValueList kvl = kvllines.get(x);
            RentalContractLine rcline = null;
            Integer rcl_id = kvl.getValueInt("rentalContractLineId");
            if (rcl_id != null) {
                int y = 0;
                while (y < rc.getLines().size()) {
                    if (rcl_id.intValue() == rc.getLines().get(y).getRentalContractLineId().intValue()) {
                        rcline = rc.getLines().get(y);
                        break;
                    }
                    ++y;
                }
            }
            if (rcline == null) {
                rcline = new RentalContractLine();
            }
            rcline.setLineType(kvl.getValue("lineType"));
            rcline.setRentalContractId(rc.getRentalContractId());
            Article art = null;
            if ("rental".equals(rcline.getLineType()) || "article".equals(rcline.getLineType())) {
                Integer articleId = kvl.getValueInt("articleId");
                art = this.articleService.readArticle(articleId);
            }
            if (art != null) {
                rcline.setArticleId(art.getArticleId());
                rcline.setDescription(art.getShortDescription());
            }
            rcline.setAmount(kvl.getValueDouble("amount"));
            if ("rental".equals(rcline.getLineType())) {
                rcline.setStartTime(kvl.getValue("startTime"));
                rcline.setEndTime(kvl.getValue("endTime"));
                rcline.setRenewalPeriod(kvl.getValueInt("renewalPeriod"));
                rcline.setRenewalType(kvl.getValue("renewalType"));
            } else if (!"article".equals(rcline.getLineType()) && "price".equals(rcline.getLineType())) {
                rcline.setDescription(kvl.getValue("lineDescription"));
            }
            Integer vatId = kvl.getValueInt("vatId");
            rcline.setVatId(vatId);
            Vat vat = null;
            if (vatId != null) {
                vat = this.articleService.readVat(vatId);
            }
            if (this.salesSettings.inputPriceExclVat()) {
                price = kvl.getValueDouble("priceExclVat");
                rcline.setPriceExclVat(price);
                rcline.calcAmountIncl(vat);
            }
            if (this.salesSettings.inputPriceInclVat()) {
                price = kvl.getValueDouble("priceInclVat");
                rcline.setPriceInclVat(price);
                rcline.calcAmountExcl(vat);
            }
            lines.add(rcline);
            ++x;
        }
        rc.setLines(lines);
        this.rentalService.save(rc);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("rentalContractId", rc.getRentalContractId());
        req.renderJson(result);
    }

    public void articleInfoAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer articleId = req.getParamInt("articleId");
        Article article = this.articleService.readArticle(articleId);
        List<RentalContractLine> lines = this.rentalService.contractsByArticle(articleId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("article", article);
        result.put("rentalContractLines", lines);
        req.renderJson(result);
    }

    public void articleRentalInfoAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer articleId = req.getParamInt("articleId");
        Article article = this.articleService.readArticle(articleId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("article", article);
        result.put("salesSettings", this.getSalesSettings());
        if ("slotplan".equals(article.getPricingMethod())) {
            Slotplan slotplan = this.slotService.readSlotplan(article.getSlotplanId());
            result.put("slotplan", slotplan);
        }
        if ("dayprice".equals(article.getPricingMethod())) {
            Dayprice dayprice = this.rentalDaypriceService.readDayprice(article.getDaypriceId());
            result.put("dayprice", dayprice);
        }
        req.renderJson(result);
    }

    public void occupationByPeriodAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer articleId = req.getParamInt("articleId");
        Date startDate = req.getParamDate("startDate");
        Date endDate = req.getParamDate("endDate");
        List<RentalContractLine> lines = this.rentalService.occupationByPeriod(articleId, startDate, endDate);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("lines", lines);
        req.renderJson(result);
    }

    public void deleteContractAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("rentalContractId");
        this.rentalService.deleteContract(id);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

