/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.sales.model.SlotplanPricetype;
import itx.erp.sales.service.SlotService;
import itx.erp.sales.validator.SlotplanPricetypeValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class SlotplanPricetypeController
extends BaseController {
    protected SlotService slotService;

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<SlotplanPricetype> pricetypes = this.slotService.readPricetypes();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pricetypes", pricetypes);
        result.put("success", true);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = req.getParamInt("slotplanPricetypeId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        this.slotService.deletePricetype(id);
        result.put("success", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = req.getParamInt("slotplanPricetypeId");
        SlotplanPricetype p = this.slotService.readPricetype(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pricetype", p);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = req.getParamInt("slotplanPricetypeId");
        SlotplanPricetype p = id != null ? this.slotService.readPricetype(id) : new SlotplanPricetype();
        p.setName(req.getParameter("name"));
        p.setActive(req.getParamBool("active"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        SlotplanPricetypeValidator v = new SlotplanPricetypeValidator();
        if (v.validate(p)) {
            id = this.slotService.savePricetype(p);
            result.put("success", true);
            result.put("slotplanPricetypeId", id);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Integer> l = NumberUtil.csl2int(req.getParameter("ids"));
        this.slotService.updatePricetypeSort(l);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

