/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Vat;
import itx.erp.sales.service.ArticleService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;

public class SalesSettingsController
extends BaseController {
    protected SalesSettings salesSettings;
    protected ArticleService articleService;

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("settings", this.salesSettings);
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        this.salesSettings.setInputPrice(req.getParameter("inputPrice"));
        this.salesSettings.setWeekPrices(req.getParamBool("weekPrices"));
        this.salesSettings.setMonthPrices(req.getParamBool("monthPrices"));
        this.salesSettings.setStartMonthInvoice(req.getParameter("startMonthInvoice"));
        this.salesSettings.setSlotplanPrices(req.getParamBool("slotplanPrices"));
        this.salesSettings.setRentalDailyStartTime(req.getParameter("rentalDailyStartTime"));
        this.salesSettings.setRentalDailyEndTime(req.getParameter("rentalDailyEndTime"));
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

