/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.ArticleGroup;
import itx.erp.sales.model.ArticleSlotplanPrice;
import itx.erp.sales.model.Slotplan;
import itx.erp.sales.model.SlotplanPricetype;
import itx.erp.sales.model.Vat;
import itx.erp.sales.rental.model.Dayprice;
import itx.erp.sales.rental.service.RentalDaypriceService;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.SlotService;
import itx.erp.sales.validator.ArticleValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class ArticleController
extends BaseController {
    protected ErpConfig appConfig;
    protected ArticleService articleService;
    protected SlotService slotService;
    protected SalesSettings salesSettings;
    protected RentalDaypriceService rentalDaypriceService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public RentalDaypriceService getRentalDaypriceService() {
        return this.rentalDaypriceService;
    }

    public void setRentalDaypriceService(RentalDaypriceService rentalDaypriceService) {
        this.rentalDaypriceService = rentalDaypriceService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        this.searchAction(req);
    }

    public void searchAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<Article> qrs = this.articleService.searchArticle(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("articles", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleId = req.getParamInt("articleId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        this.articleService.deleteArticle(articleId);
        result.put("success", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleId = req.getParamInt("articleId");
        Article a = this.articleService.readArticle(articleId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("article", a);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleId = req.getParamInt("articleId");
        Article article = articleId != null ? this.articleService.readArticle(articleId) : new Article();
        article.setShortDescription(req.getParameter("shortDescription"));
        article.setRentable(req.getParamBool("rentable"));
        article.setOverbookable(req.getParamBool("overbookable"));
        article.setMaxBookable(req.getParamInt("maxBookable"));
        article.setVatId(req.getParamInt("vatId"));
        article.setActive(req.getParamBool("active"));
        article.setLongDescription(req.getParameter("longDescription"));
        article.setPricingMethod(req.getParameter("pricingMethod"));
        if (this.salesSettings.inputPriceExclVat()) {
            article.setPriceExclVat(req.getParamCurrencyAsDouble("price"));
        } else if (this.salesSettings.inputPriceInclVat()) {
            article.setPriceInclVat(req.getParamCurrencyAsDouble("price"));
        }
        article.setSlotplanId(req.getParamInt("slotplanId"));
        article.getSlotplanPrices().clear();
        article.setDaypriceId(req.getParamInt("daypriceId"));
        Slotplan p = null;
        if (article.getSlotplanId() != null) {
            p = this.slotService.readSlotplan(article.getSlotplanId());
        }
        if (p != null) {
            for (String param : req.getParameterNames()) {
                Integer pricetypeId;
                if (!param.startsWith("pricetype-") || !p.hasPricetypeId(pricetypeId = NumberUtil.tryParseInt(param.replace("pricetype-", "")))) continue;
                String strp = req.getParameter(param);
                Double price = NumberUtil.tryCurrencyToDouble(strp);
                ArticleSlotplanPrice asp = new ArticleSlotplanPrice();
                asp.setSlotplanPricetypeId(pricetypeId);
                if (this.salesSettings.inputPriceExclVat()) {
                    asp.setPriceExclVat(price);
                } else if (this.salesSettings.inputPriceInclVat()) {
                    asp.setPriceInclVat(price);
                }
                article.getSlotplanPrices().add(asp);
            }
        }
        for (String param : req.getParameterNames()) {
            Integer articleGroupId;
            if (!param.startsWith("linked_ag_") || (articleGroupId = req.getParamInt(param)) == null) continue;
            article.getArticleGroupIds().add(articleGroupId);
        }
        article.setMainArticleGroupId(req.getParamInt("main_article_group_id"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArticleValidator v = new ArticleValidator();
        if (v.validate(article)) {
            articleId = this.articleService.saveArticle(article);
            result.put("success", true);
            result.put("articleId", articleId);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        List<ArticleGroup> groups = this.articleService.readArticleGroups();
        List<Vat> vats = this.articleService.readVats();
        List<Slotplan> slotplans = this.slotService.listSlotplans();
        List<SlotplanPricetype> pricetypes = this.slotService.readPricetypes();
        List<Dayprice> dayprices = this.rentalDaypriceService.readAllDayprices();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("salesSettings", this.salesSettings);
        result.put("groups", groups);
        result.put("vats", vats);
        result.put("slotplans", slotplans);
        result.put("pricetypes", pricetypes);
        result.put("dayprices", dayprices);
        result.put("success", true);
        req.renderJson(result);
    }
}

