/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.conf;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import jtbcore.util.DateUtil;

@JsonIgnoreProperties(value={"appConfig"})
public class SalesSettings {
    protected ErpConfig appConfig;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public String getInputPrice() throws SQLException {
        String p = this.appConfig.getSetting("input_price");
        if ("incl_vat".equals(p) || "excl_vat".equals(p)) {
            return p;
        }
        return "excl_vat";
    }

    public void setInputPrice(String m) throws SQLException, IOException {
        this.appConfig.setSetting("input_price", m);
    }

    public boolean inputPriceExclVat() {
        try {
            return "excl_vat".equals(this.getInputPrice());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean inputPriceInclVat() {
        try {
            return "incl_vat".equals(this.getInputPrice());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean getWeekPrices() throws SQLException {
        return this.appConfig.getSettingInt("sales_weekPrices", 0) > 0;
    }

    public void setWeekPrices(Boolean b) throws SQLException, IOException {
        this.appConfig.setSetting("sales_weekPrices", b != false ? 1 : 0);
    }

    public Boolean getMonthPrices() throws SQLException {
        return this.appConfig.getSettingInt("sales_monthPrices", 1) > 0;
    }

    public void setMonthPrices(Boolean b) throws SQLException, IOException {
        this.appConfig.setSetting("sales_monthPrices", b != false ? 1 : 0);
    }

    public String getStartMonthInvoice() throws SQLException {
        return this.appConfig.getSetting("sales_startMonthInvoice");
    }

    public void setStartMonthInvoice(String m) throws SQLException, IOException {
        this.appConfig.setSetting("sales_startMonthInvoice", m);
    }

    public Boolean getSlotplanPrices() throws SQLException {
        return this.appConfig.getSettingInt("sales_slotplanPrices", 0) > 0;
    }

    public void setSlotplanPrices(Boolean b) throws SQLException, IOException {
        this.appConfig.setSetting("sales_slotplanPrices", b != false ? 1 : 0);
    }

    public String getRentalDailyStartTime() throws SQLException {
        return this.appConfig.getSetting("sales_rentalDailyStartTime", "08:00");
    }

    public void setRentalDailyStartTime(String p) throws SQLException, IOException {
        if (!DateUtil.validTime(p)) {
            return;
        }
        this.appConfig.setSetting("sales_rentalDailyStartTime", p);
    }

    public String getRentalDailyEndTime() throws SQLException {
        return this.appConfig.getSetting("sales_rentalDailyEndTime", "22:00");
    }

    public void setRentalDailyEndTime(String p) throws SQLException, IOException {
        if (!DateUtil.validTime(p)) {
            return;
        }
        this.appConfig.setSetting("sales_rentalDailyEndTime", p);
    }
}

