/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.gui;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.WebSession;
import itx.erp.helper.ErpConfig;
import java.awt.SplashScreen;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class BrowserStage
extends Stage {
    protected BorderPane root;
    protected WebView webView;

    public BrowserStage() {
        final ErpObjectContainer objectContainer = ErpObjectContainer.getInstance();
        this.root = new BorderPane();
        Object url = System.getProperty("erp.weburl");
        try {
            WebSession ws = objectContainer.getWebSessionService().getLocalAdminSession();
            url = (String)url + "?jtbauth=" + ws.getCookieValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.webView = new WebView();
        if (this.webView.getEngine().getUserAgent().indexOf("JavaFX") == -1) {
            this.webView.getEngine().setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/616.1 (KHTML, like Gecko) JavaFX/21 Safari/616.1");
        }
        this.webView.getEngine().load((String)url);
        this.root.setCenter((Node)this.webView);
        Scene s = new Scene((Parent)this.root);
        this.setScene(s);
        try {
            ErpConfig ac1 = objectContainer.getAppConfig();
            Integer w1 = ac1.getSettingInt("app_width", 1000);
            Integer h1 = ac1.getSettingInt("app_height", 700);
            if (w1 != null) {
                this.setWidth(w1.intValue());
            }
            if (h1 != null) {
                this.setHeight(h1.intValue());
            }
        }
        catch (Exception ac1) {
            // empty catch block
        }
        this.centerOnScreen();
        String appName = objectContainer.getProperty("publicAppName");
        String pubv = objectContainer.getProperty("publicVersion");
        this.setTitle(appName + " " + pubv);
        ChangeListener<Number> clwidth = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    objectContainer.getAppConfig().setSetting("app_width", newValue.intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ChangeListener<Number> clheight = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    objectContainer.getAppConfig().setSetting("app_height", newValue.intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.setOnHiding(arg_0 -> BrowserStage.lambda$0(s, (ChangeListener)clwidth, (ChangeListener)clheight, arg_0));
        this.setOnShown(arg_0 -> this.lambda$1(objectContainer, s, (ChangeListener)clwidth, (ChangeListener)clheight, arg_0));
    }

    private static /* synthetic */ void lambda$0(Scene scene, ChangeListener changeListener, ChangeListener changeListener2, WindowEvent e) {
        scene.widthProperty().removeListener(changeListener);
        scene.heightProperty().removeListener(changeListener2);
    }

    private /* synthetic */ void lambda$1(ErpObjectContainer erpObjectContainer, Scene scene, ChangeListener changeListener, ChangeListener changeListener2, WindowEvent evt) {
        Integer width = null;
        Integer height = null;
        try {
            ErpConfig appConfig = erpObjectContainer.getAppConfig();
            width = appConfig.getSettingInt("app_width", 1000);
            height = appConfig.getSettingInt("app_height", 700);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (width == null || width < 100) {
            width = 100;
        }
        if (height == null || height < 100) {
            height = 100;
        }
        System.out.println("w/h: " + String.valueOf(width) + " / " + String.valueOf(height));
        this.setWidth(width.intValue());
        this.setHeight(height.intValue());
        scene.widthProperty().addListener(changeListener);
        scene.heightProperty().addListener(changeListener2);
        this.centerOnScreen();
        if (SplashScreen.getSplashScreen() != null) {
            SplashScreen.getSplashScreen().close();
        }
    }
}

