/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.WebRequest;
import itx.core.web.filter.RequestAuthFilter;
import itx.core.web.filter.RequestFilterList;
import itx.core.web.filter.RequestRouteFilter;
import itx.erp.ErpObjectContainer;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.ContainerException;
import jtbcore.exception.JTBException;

public class RouterController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected ErpObjectContainer objectContainer = ErpObjectContainer.getInstance();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String r = config.getServletContext().getRealPath(".");
        try {
            this.objectContainer.getAppConfig().setServletRoot(r);
        }
        catch (ContainerException e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Headers", "*");
        resp.setHeader("Access-Control-Expose-Headers", "*");
        resp.setHeader("Connection", "close");
        WebRequest webReq = new WebRequest(req, resp);
        try {
            RequestFilterList rfl = new RequestFilterList();
            rfl.addFilter(new RequestRouteFilter());
            rfl.addFilter(new RequestAuthFilter());
            rfl.execute(webReq);
            webReq.getController().handleRequest(webReq);
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof AuthorizationException) {
                System.err.println("Error: user " + String.valueOf(webReq.getUserId()) + ", " + req.getContextPath() + webReq.getRouteUrl() + ": " + ex.getCause().getMessage());
            } else {
                ex.printStackTrace();
            }
            HashMap<String, Object> err = new HashMap<String, Object>();
            err.put("error", true);
            err.put("success", false);
            if (ex.getCause() != null && ex.getCause() instanceof JTBException) {
                err.put("message", ex.getCause().getMessage());
            } else if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                err.put("message", ex.getCause().getMessage());
            } else if (ex instanceof JTBException) {
                err.put("message", ex.getMessage());
            } else {
                err.put("message", ex.toString());
            }
            resp.setStatus(500);
            resp.setContentType("application/json");
            ObjectMapper om = new ObjectMapper();
            om.writeValue((OutputStream)resp.getOutputStream(), err);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Headers", "*");
        resp.setHeader("Access-Control-Expose-Headers", "*");
        resp.setHeader("Connection", "close");
    }
}

