/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.task;

import itx.erp.base.model.User;
import itx.erp.base.service.MetaService;
import itx.erp.base.service.UserService;
import itx.erp.base.util.LangUtil;
import itx.erp.contracts.model.ContractSettings;
import itx.erp.contracts.model.ContractTask;
import itx.erp.contracts.model.ContractTaskUserMeta;
import itx.erp.contracts.service.ContractService;
import itx.erp.helper.ErpConfig;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.model.EmailTemplate;
import itx.erp.webmail.service.EmailService;
import itx.erp.webmail.service.EmailTemplateService;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.MessagingException;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.exception.RemoteApiException;
import jtbcore.util.DateUtil;
import jtbcore.util.StringUtil;
import org.apache.commons.validator.EmailValidator;

public class ContractAlertMail {
    protected ErpConfig appConfig;
    protected UserService userService;
    protected ContractService contractService;
    protected EmailService emailService;
    protected EmailTemplateService emailTemplateService;
    protected ContractSettings contractSettings;
    protected MetaService metaService;
    protected EmailTemplate etDaily = null;
    protected EmailTemplate etWeekly = null;

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setContractSettings(ContractSettings contractSettings) {
        this.contractSettings = contractSettings;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public EmailTemplate getTemplateDaily() throws SQLException, JTBException {
        if (this.etDaily == null) {
            this.etDaily = this.emailTemplateService.readByCode("CONTRACT_DAILY_ALERTS");
        }
        return this.etDaily;
    }

    public EmailTemplate getTemplateWeekly() throws SQLException, JTBException {
        if (this.etWeekly == null) {
            this.etWeekly = this.emailTemplateService.readByCode("CONTRACT_WEEKLY_UPDATE");
        }
        return this.etWeekly;
    }

    public void handleWeekly() throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        if (!this.sendWeekly()) {
            return;
        }
        this.metaService.setMeta("contract", "weekly_update_date", DateUtil.date2string(new Date()));
        List<Integer> userids = this.userService.listAllIds();
        for (Integer userid : userids) {
            if (!this.contractService.hasWeeklyUpdate(userid)) continue;
            this.sendWeekly(userid);
        }
    }

    protected boolean sendWeekly() throws SQLException {
        if (!this.contractSettings.getWeeklySummary()) {
            return false;
        }
        String lastdate = this.metaService.getMetaNameKey("contract", "weekly_update_date");
        int summaryDay = this.contractSettings.getWeeklySummaryDay();
        if (lastdate == null) {
            return new Date().getDay() == summaryDay;
        }
        Date last = DateUtil.string2date(lastdate);
        if (last == null) {
            return new Date().getDay() == summaryDay;
        }
        if (DateUtil.date2ymd(last) == DateUtil.ymdNow()) {
            return false;
        }
        int daysbetween = DateUtil.daysBetween(lastdate, new Date());
        if (daysbetween > 7) {
            return true;
        }
        return last.getDay() == summaryDay;
    }

    public void handleDaily() throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        if (!this.contractSettings.getDailyAlerts()) {
            return;
        }
        int dayno = new Date().getDay();
        if (!this.contractSettings.dailyAlertEnabled(dayno)) {
            return;
        }
        String ymdToday = DateUtil.date2string(new Date());
        if (ymdToday.equals(this.metaService.getMetaNameKey("contract", "daily_sent_date"))) {
            return;
        }
        this.metaService.setMeta("contract", "daily_sent_date", ymdToday);
        List<Integer> userIds = this.userService.listAllIds();
        for (Integer userId : userIds) {
            if (!this.contractService.hasDailyAlerts(userId)) continue;
            User user = this.userService.readUser(userId);
            this.sendDaily(user, this.contractSettings.getDailyZeroUpdates(), false);
        }
    }

    public void sendWeekly(Integer userId) throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        User user = this.userService.readUser(userId);
        this.sendWeekly(user);
    }

    public void sendWeekly(User user) throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        String html_count_stat;
        if (user.getEmail() == null || !EmailValidator.getInstance().isValid(user.getEmail())) {
            return;
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        if (!user.isAdmin()) {
            opts.put("allowedUserId", user.getUserId());
        }
        opts.put("status_open", true);
        opts.put("status_inprogress", true);
        opts.put("status_done", false);
        opts.put("upcoming", false);
        opts.put("limit", 1000);
        QueryResult<ContractTask> qr = this.contractService.searchTasks(opts);
        StringBuilder html_contract_alerts = new StringBuilder();
        int countOpen = 0;
        int countInprogress = 0;
        if (qr.getRowCount() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            html_contract_alerts.append("<table>\n");
            html_contract_alerts.append("<thead>\n");
            html_contract_alerts.append("  <tr>\n");
            html_contract_alerts.append("    <th align=left>Contract #</th>");
            html_contract_alerts.append("    <th align=left>Contract</th>");
            html_contract_alerts.append("    <th align=left>Klant</th>");
            html_contract_alerts.append("    <th align=left>Taak omschrijving</th>");
            html_contract_alerts.append("    <th align=left>Alert datum</th>");
            html_contract_alerts.append("    <th align=left>Status</th>");
            html_contract_alerts.append("  </tr>\n");
            html_contract_alerts.append("</thead>\n");
            for (ContractTask ct : qr.getObjects()) {
                String contractName = StringUtil.escapeHtml(ct.getBaseStringMap().getProperty("contract_name"));
                String customerName = StringUtil.escapeHtml(ct.getBaseStringMap().getProperty("customer_name"));
                String taskName = StringUtil.escapeHtml(ct.getDescription());
                Date nextAlert = ct.getNextAlertDate();
                String status = LangUtil.getInstance().t(ct.getNextStatus());
                html_contract_alerts.append("<tr>\n");
                html_contract_alerts.append("  <td>").append(ct.getContractId()).append("</td>");
                String contractUrl = this.appConfig.buildAdminUrl("/contracts/edit/?id=" + String.valueOf(ct.getContractId()));
                html_contract_alerts.append("  <td>").append("<a href=\"" + contractUrl + "\">" + contractName + "</a>").append("</td>");
                Integer customerId = ct.getBaseStringMap().getPropertyInt("customer_id");
                if (customerName != null) {
                    String customerUrl = this.appConfig.buildAdminUrl("/customers/edit/?id=" + String.valueOf(customerId));
                    html_contract_alerts.append("  <td>").append("<a href=\"" + customerUrl + "\">" + customerName + "</a>").append("</td>");
                } else {
                    html_contract_alerts.append("  <td>").append("customer-" + String.valueOf(customerId)).append("</td>");
                }
                html_contract_alerts.append("  <td>").append(taskName).append("</td>");
                html_contract_alerts.append("  <td>").append(nextAlert != null ? sdf.format(nextAlert) : "").append("</td>");
                html_contract_alerts.append("  <td>").append(status).append("</td>");
                html_contract_alerts.append("</tr>\n");
                if ("open".equals(ct.getNextStatus())) {
                    ++countOpen;
                    continue;
                }
                if (!"inprogress".equals(ct.getNextStatus())) continue;
                ++countInprogress;
            }
            html_contract_alerts.append("</table>\n");
        } else {
            html_contract_alerts.append("<div>Geen openstaande taken</div>");
        }
        String html_alert_summary = html_count_stat = countOpen + "x Open, " + countInprogress + "x In behandeling";
        HashMap<String, String> emailvars = new HashMap<String, String>();
        emailvars.put("alert_summary", html_alert_summary);
        emailvars.put("contract_alerts", html_count_stat + "<hr/>" + html_contract_alerts.toString());
        EmailMessage em = this.getTemplateWeekly().buildmessage(emailvars);
        em.addTo(user.getEmail(), user.getDisplayName());
        this.emailService.sendMail(em);
    }

    public void sendDaily(Integer userId, boolean sendNullMessage, boolean skipMarkedSent) throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        User user = this.userService.readUser(userId);
        this.sendDaily(user, sendNullMessage, skipMarkedSent);
    }

    public void sendDaily(User user, boolean sendNullMessage, boolean skipMarkedSent) throws SQLException, JTBException, IOException, MessagingException, RemoteApiException {
        String html_count_stat;
        if (user.getEmail() == null || !EmailValidator.getInstance().isValid(user.getEmail())) {
            return;
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        if (!user.isAdmin()) {
            opts.put("allowedUserId", user.getUserId());
        }
        opts.put("status_open", true);
        opts.put("status_inprogress", true);
        opts.put("status_done", false);
        opts.put("upcoming", false);
        opts.put("limit", 1000);
        QueryResult<ContractTask> qr = this.contractService.searchTasks(opts);
        StringBuilder html_contract_alerts = new StringBuilder();
        int countOpen = 0;
        int countInprogress = 0;
        int ymdtoday = DateUtil.date2ymd(new Date());
        if (qr.getRowCount() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            html_contract_alerts.append("<table>\n");
            html_contract_alerts.append("<thead>\n");
            html_contract_alerts.append("  <tr>\n");
            html_contract_alerts.append("    <th align=left>Contract #</th>");
            html_contract_alerts.append("    <th align=left>Contract</th>");
            html_contract_alerts.append("    <th align=left>Klant</th>");
            html_contract_alerts.append("    <th align=left>Taak omschrijving</th>");
            html_contract_alerts.append("    <th align=left>Alert datum</th>");
            html_contract_alerts.append("    <th align=left>Status</th>");
            html_contract_alerts.append("  </tr>\n");
            html_contract_alerts.append("</thead>\n");
            for (ContractTask ct : qr.getObjects()) {
                Date nextAlert;
                int ymdct;
                ContractTaskUserMeta m;
                if (skipMarkedSent && (m = this.contractService.readTaskUserMeta(ct.getContractTaskId(), user.getUserId())) != null && m.getDailyAlertSent() != null || (ymdct = DateUtil.daysBetween(nextAlert = ct.getNextAlertDate(), new Date())) > 14) continue;
                String contractName = StringUtil.escapeHtml(ct.getBaseStringMap().getProperty("contract_name"));
                String customerName = StringUtil.escapeHtml(ct.getBaseStringMap().getProperty("customer_name"));
                String taskName = StringUtil.escapeHtml(ct.getDescription());
                String status = LangUtil.getInstance().t(ct.getNextStatus());
                html_contract_alerts.append("<tr>\n");
                html_contract_alerts.append("  <td>").append(ct.getContractId()).append("</td>");
                String contractUrl = this.appConfig.buildAdminUrl("/contracts/edit/?id=" + String.valueOf(ct.getContractId()));
                html_contract_alerts.append("  <td>").append("<a href=\"" + contractUrl + "\">" + contractName + "</a>").append("</td>");
                Integer customerId = ct.getBaseStringMap().getPropertyInt("customer_id");
                if (customerName != null) {
                    String customerUrl = this.appConfig.buildAdminUrl("/customers/edit/?id=" + String.valueOf(customerId));
                    html_contract_alerts.append("  <td>").append("<a href=\"" + customerUrl + "\">" + customerName + "</a>").append("</td>");
                } else {
                    html_contract_alerts.append("  <td>").append("customer-" + String.valueOf(customerId)).append("</td>");
                }
                html_contract_alerts.append("  <td>").append(taskName).append("</td>");
                html_contract_alerts.append("  <td>").append(nextAlert != null ? sdf.format(nextAlert) : "").append("</td>");
                html_contract_alerts.append("  <td>").append(status).append("</td>");
                html_contract_alerts.append("</tr>\n");
                if ("open".equals(ct.getNextStatus())) {
                    ++countOpen;
                } else if ("inprogress".equals(ct.getNextStatus())) {
                    ++countInprogress;
                }
                this.contractService.markDailyAlertSent(ct.getContractTaskId(), user.getUserId());
            }
            if (countOpen == 0 && countInprogress == 0) {
                html_contract_alerts.append("<tr>\n");
                html_contract_alerts.append("  <td colspan=\"100%\" style=\"text-align: center; font-style: italic; padding: 25px 0;\">Geen resultaten</td>");
                html_contract_alerts.append("</tr>\n");
            }
            html_contract_alerts.append("</table>\n");
        } else {
            html_contract_alerts.append("<div>Geen openstaande taken</div>");
        }
        if (!sendNullMessage && countOpen == 0 && countInprogress == 0) {
            return;
        }
        String html_alert_summary = html_count_stat = countOpen + "x Open, " + countInprogress + "x In behandeling";
        HashMap<String, String> emailvars = new HashMap<String, String>();
        emailvars.put("alert_summary", html_alert_summary);
        emailvars.put("contract_alerts", html_count_stat + "<hr/>" + html_contract_alerts.toString());
        EmailMessage em = this.getTemplateDaily().buildmessage(emailvars);
        em.addTo(user.getEmail(), user.getDisplayName());
        this.emailService.sendMail(em);
    }
}

