/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import itx.contracts.ContractsObjectContainer;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.UserPermission;
import itx.erp.contracts.model.ContractTask;
import itx.erp.contracts.model.ContractType;
import itx.erp.contracts.service.ContractService;
import itx.erp.customer.model.Customer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.DateUtil;

public class Contract
implements BaseStringMapObject {
    protected BaseStringMap bsm;
    protected Customer customer;
    protected List<ContractTask> tasks;
    protected List<DbFile> files;
    protected List<Contract> relatedContracts;
    protected List<UserPermission> permissions = new ArrayList<UserPermission>();
    protected Boolean allowView = true;

    public Contract() {
        this.bsm = new BaseStringMap();
    }

    public Boolean getAllowView() {
        return this.allowView;
    }

    public void setAllowView(Boolean allowEdit) {
        this.allowView = allowEdit;
    }

    public Integer getContractId() {
        return this.bsm.getPropertyInt("contract_id");
    }

    public void setContractId(Integer i) {
        this.bsm.setProperty("contract_id", i);
    }

    public Integer getContractTypeId() {
        return this.bsm.getPropertyInt("contract_type_id");
    }

    public void setContractTypeId(Integer i) {
        this.bsm.setProperty("contract_type_id", i);
    }

    public Integer getCustomerId() {
        return this.bsm.getPropertyInt("customer_id");
    }

    public void setCustomerId(Integer i) {
        this.bsm.setProperty("customer_id", i);
    }

    public String getName() {
        return this.bsm.getProperty("name");
    }

    public void setName(String i) {
        this.bsm.setProperty("name", i);
    }

    public String getAmountDescription() {
        return this.bsm.getProperty("amount_description");
    }

    public void setAmountDescription(String i) {
        this.bsm.setProperty("amount_description", i);
    }

    public Date getStartDate() {
        return this.bsm.getPropertyDate("start_date");
    }

    public void setStartDate(Date i) {
        this.bsm.setProperty("start_date", i);
    }

    public Date getEndDate() {
        return this.bsm.getPropertyDate("end_date");
    }

    public void setEndDate(Date i) {
        this.bsm.setProperty("end_date", i);
    }

    public Date getRenewalDate() {
        if (this.getEndDate() == null || this.getTimeNotice() == null || this.getTimeNoticeUnit() == null) {
            return null;
        }
        return DateUtil.calcDate(this.getEndDate(), this.getTimeNoticeUnit(), this.getTimeNotice() * -1);
    }

    public Integer getTimeNotice() {
        Integer i = this.bsm.getPropertyInt("time_notice");
        return i == null ? 0 : i;
    }

    public void setTimeNotice(Integer i) {
        this.bsm.setProperty("time_notice", i);
    }

    public String getTimeNoticeUnit() {
        String tnu = this.bsm.getProperty("time_notice_unit");
        if (tnu != null) {
            return tnu;
        }
        return "month";
    }

    public void setTimeNoticeUnit(String i) {
        this.bsm.setProperty("time_notice_unit", i);
    }

    public Integer getRenewPeriod() {
        return this.bsm.getPropertyInt("renew_period");
    }

    public void setRenewPeriod(Integer i) {
        this.bsm.setProperty("renew_period", i);
    }

    public String getRenewUnit() {
        String tnu = this.bsm.getProperty("renew_unit");
        if (tnu != null) {
            return tnu;
        }
        return "month";
    }

    public void setRenewUnit(String i) {
        this.bsm.setProperty("renew_unit", i);
    }

    public String getStatus() {
        return this.bsm.getProperty("status");
    }

    public void setStatus(String i) {
        this.bsm.setProperty("status", i);
    }

    public boolean getAutoRenew() {
        return this.isAutoRenew();
    }

    public boolean isAutoRenew() {
        return this.bsm.getPropertyBool("auto_renew");
    }

    public void setAutoRenew(Boolean b) {
        this.bsm.setProperty("auto_renew", b == null || b == false ? "0" : "1");
    }

    public String getNote() {
        return this.bsm.getProperty("note");
    }

    public void setNote(String i) {
        this.bsm.setProperty("note", i);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDateTime("edited");
    }

    public Date getCreated() {
        return this.bsm.getPropertyDateTime("created");
    }

    @JsonIgnore
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String getContractTypeName() {
        if (this.bsm.hasProperty("contract_type_name") && this.bsm.getProperty("contract_type_name") != null) {
            return this.bsm.getProperty("contract_type_name");
        }
        if (this.getContractTypeId() != null) {
            try {
                ContractsObjectContainer oc = ContractsObjectContainer.getInstance();
                ContractService cs = oc.getContractService();
                ContractType ct = cs.readContractType(this.getContractTypeId());
                if (ct != null) {
                    return ct.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getCustomerName() {
        if (this.customer != null) {
            return this.customer.getCustomerName();
        }
        if (this.bsm.hasProperty("customer_name") && this.bsm.getProperty("customer_name") != null) {
            return this.bsm.getProperty("customer_name");
        }
        if (this.bsm.hasProperty("customer_id") && this.bsm.getProperty("customer_id") != null) {
            return "customer-" + this.bsm.getProperty("customer_id");
        }
        return null;
    }

    public List<ContractTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<ContractTask> tasks) {
        this.tasks = tasks;
    }

    public List<DbFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<DbFile> files) {
        this.files = files;
    }

    public List<Contract> getRelatedContracts() {
        return this.relatedContracts;
    }

    public void setRelatedContracts(List<Contract> relatedContracts) {
        this.relatedContracts = relatedContracts;
    }

    public List<UserPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<UserPermission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(UserPermission cp) {
        this.permissions.add(cp);
    }

    public List<String> getPermissionDescriptions() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.permissions != null) {
            for (UserPermission up : this.permissions) {
                try {
                    if (up.getUserId() != null) {
                        String username = (String)ErpObjectContainer.getInstance().getSqlConnection().queryValue("select username from base__user where user_id = ?", String.class, up.getUserId());
                        l.add(username + " - " + up.getAccessMethod());
                    }
                    if (up.getGroupId() == null) continue;
                    String groupname = (String)ErpObjectContainer.getInstance().getSqlConnection().queryValue("select group_name from base__user_group where user_group_id = ?", String.class, up.getGroupId());
                    l.add(groupname + " - " + up.getAccessMethod());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return l;
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

