/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.service.UserService;
import itx.erp.base.util.LangUtil;
import itx.erp.contracts.model.Contract;
import itx.erp.contracts.model.ContractTask;
import itx.erp.contracts.model.ContractTaskEvent;
import itx.erp.contracts.service.ContractService;
import itx.erp.contracts.task.ContractAlertMail;
import itx.erp.contracts.validator.ContractTaskValidator;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import jtbcore.db.common.QueryResult;
import jtbcore.db.export.ExcelExporter;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.exception.RemoteApiException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.DateUtil;
import jtbcore.util.ListUtil;
import jtbcore.util.ProcUtil;
import org.apache.commons.validator.EmailValidator;

public class ContractTaskController
extends BaseController {
    protected ErpConfig appConfig;
    protected ContractService contractService;
    protected ContractAlertMail contractAlertMail;
    protected UserService userService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    public ContractAlertMail getContractAlertMail() {
        return this.contractAlertMail;
    }

    public void setContractAlertMail(ContractAlertMail contractAlertMail) {
        this.contractAlertMail = contractAlertMail;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void listContractAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("contractId");
        if (!this.contractService.hasPermission(req.getUserId(), id)) {
            throw new AuthorizationException("No permission to contract");
        }
        List<ContractTask> tasks = this.contractService.readTasks(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("tasks", tasks);
        req.renderJson(result);
    }

    public void searchTasksAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        Integer pageNo = req.getParamInt("pageNo", 0);
        Integer start = this.appConfig.getLimit() * pageNo;
        opts.put("start", start);
        opts.put("pageSize", this.appConfig.getLimit());
        Integer pageSize = req.getParamInt("pageSize");
        if (pageSize != null) {
            opts.put("pageSize", pageSize);
        }
        opts.put("status_open", req.getParamBool("status_open"));
        opts.put("status_inprogress", req.getParamBool("status_inprogress"));
        opts.put("status_done", req.getParamBool("status_done"));
        opts.put("q", req.getParameter("q"));
        opts.put("upcoming", req.getParamBool("upcoming"));
        opts.put("dashboardRequest", req.getParamBool("dashboardRequest"));
        Integer userId = req.getUserId();
        opts.put("allowedUserId", userId);
        QueryResult<ContractTask> tasks = this.contractService.searchTasks(opts);
        ArrayList<Map<String, String>> recs = new ArrayList<Map<String, String>>();
        int x = 0;
        while (x < tasks.getObjects().size()) {
            ContractTask ct = tasks.getObjects().get(x);
            BaseStringMap b = ct.getBaseStringMap();
            b.setProperty("next_alert_date", ct.getNextAlertDate());
            b.setProperty("next_status", ct.getNextStatus());
            recs.add(b.getMap());
            ++x;
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("success", Boolean.valueOf(true));
        result.put("tasks", recs);
        result.put("start", tasks.getStart());
        result.put("pageSize", tasks.getPageSize());
        result.put("rowCount", tasks.getRowCount());
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        ContractTask ct;
        Integer id = req.getParamInt("contractTaskId");
        if (id != null) {
            ct = this.contractService.readTask(id);
            if (!this.contractService.hasWritePermission(req.getUserId(), ct.getContractId())) {
                throw new AuthorizationException("Access denied");
            }
        } else {
            ct = new ContractTask();
        }
        ct.setContractId(req.getParamInt("contractId"));
        ct.setDescription(req.getParameter("description"));
        ct.setActive(req.getParamBool("active"));
        ct.setNoticeMoment(req.getParameter("noticeMoment"));
        ct.setTaskDate(req.getParamDate("taskDate"));
        ct.setTimeNotice(req.getParamInt("timeNotice"));
        ct.setTimeNoticeUnit(req.getParameter("timeNoticeUnit"));
        ct.setNote(req.getParameter("note"));
        if (!this.contractService.hasPermission(req.getUserId(), ct.getContractId())) {
            throw new AuthorizationException("No permission to contract");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ContractTaskValidator v = new ContractTaskValidator();
        if (v.validate(ct)) {
            this.contractService.saveTask(ct, req.getUserId());
            result.put("success", true);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer id = req.getParamInt("contractTaskId");
        ContractTask ct = this.contractService.readTask(id);
        if (!this.contractService.hasPermission(req.getUserId(), ct.getContractId())) {
            throw new AuthorizationException("No permission to contract");
        }
        boolean writable = this.contractService.hasWritePermission(req.getUserId(), ct.getContractId());
        Contract contract = this.contractService.readContract(ct.getContractId());
        List<ContractTaskEvent> events = ct.getEvents();
        ct.setEvents(ListUtil.reverse(events));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("writable", writable);
        result.put("contractTask", ct);
        result.put("contract", contract);
        req.renderJson(result);
    }

    public void deleteTaskAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer tid = req.getParamInt("contractTaskId");
        ContractTask ct = this.contractService.readTask(tid);
        if (!this.contractService.hasWritePermission(req.getUserId(), ct.getContractId())) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.deleteTask(tid, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void updateTaskEventAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer eventid = req.getParamInt("contractTaskEventId");
        String note = req.getParameter("note");
        String status = req.getParameter("status");
        ContractTaskEvent cte = this.contractService.readTaskEvent(eventid);
        if (!this.contractService.hasWritePermission(req.getUserId(), cte.getContractId())) {
            throw new AuthorizationException("No permission to contract");
        }
        this.contractService.updateTaskEventStatus(eventid, status, note);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void exportAction(WebRequest req) throws SQLException, IOException, JTBException {
        String tempfile = ErpObjectContainer.getInstance().getTempFile("contracttasks-export-" + DateUtil.date2string(new Date()) + ".xlsx");
        HashMap<String, Object> opts = new HashMap<String, Object>();
        Integer start = 0;
        Integer pageSize = 100;
        opts.put("start", start);
        opts.put("pageSize", pageSize);
        opts.put("status_open", req.getParamBool("status_open"));
        opts.put("status_inprogress", req.getParamBool("status_inprogress"));
        opts.put("status_done", req.getParamBool("status_done"));
        opts.put("q", req.getParameter("q"));
        opts.put("upcoming", req.getParamBool("upcoming"));
        opts.put("dashboardRequest", false);
        Integer userId = req.getUserId();
        opts.put("allowedUserId", userId);
        LangUtil lu = LangUtil.getInstance();
        QueryResult<ContractTask> qr = null;
        qr = this.contractService.searchTasks(opts);
        ExcelExporter e = new ExcelExporter(tempfile);
        e.writeHeader(new String[]{"#", "Contract", "Relatie", "Taak omschrijving", "Alert datum", "Status"});
        int counter = 0;
        do {
            System.out.println("loopie");
            List<ContractTask> ctasks = qr.getObjects();
            int x = 0;
            while (x < ctasks.size()) {
                ContractTask ct = ctasks.get(x);
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(ct.getContractId());
                row.add(ct.getBaseStringMap().getProperty("contract_name"));
                row.add(ct.getBaseStringMap().getProperty("customer_name"));
                row.add(ct.getDescription());
                row.add(ct.getNextAlertDate());
                row.add(lu.t(ct.getNextStatus()));
                e.writeRow(row);
                ++x;
            }
            start = start + pageSize;
            opts.put("start", start);
            if (start > qr.getRowCount()) break;
            qr = this.contractService.searchTasks(opts);
        } while (counter++ <= 100000);
        e.closeFile();
        if (req.isEmbeddedRequest()) {
            ProcUtil.openUrlInBrowser(tempfile);
        } else {
            req.outputFile(tempfile);
        }
    }

    public void sendWeeklyUpdateAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException, MessagingException, RemoteApiException {
        Integer userId = req.getParamInt("userId");
        User user = this.userService.readUser(userId);
        if (!EmailValidator.getInstance().isValid(user.getEmail())) {
            throw new InvalidStateException("No valid e-mailaddress set");
        }
        this.contractAlertMail.sendWeekly(userId);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void sendDailyAlertsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException, MessagingException, RemoteApiException {
        Integer userId = req.getParamInt("userId");
        User user = this.userService.readUser(userId);
        if (!EmailValidator.getInstance().isValid(user.getEmail())) {
            throw new InvalidStateException("No valid e-mailaddress set");
        }
        this.contractAlertMail.sendDaily(userId, true, false);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

