/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.model.validator;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.service.UserService;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.ContainerException;
import jtbcore.model.validator.BaseValidator;
import jtbcore.model.validator.ValidatorResult;
import jtbcore.util.MapUtil;

public class UserValidator
extends BaseValidator<User> {
    protected UserService userService = ErpObjectContainer.getInstance().getUserService();

    public UserValidator() throws ContainerException {
        super.addValidator("userId", null);
        super.addValidator("firstname", null);
        super.addValidator("lastname", null);
        super.addValidator("activated", null);
        super.addValidator("password", null);
        super.addValidator("userType", null);
        super.addValidator("username", u -> {
            String n = u.getUsername();
            if (n == null) {
                return new ValidatorResult(false, "verplicht");
            }
            if ((n = n.trim()).length() == 0) {
                return new ValidatorResult(false, "verplicht");
            }
            try {
                QueryResult<User> qr = this.userService.searchUsers(MapUtil.createStringObjectMap("username", u.getUsername()));
                for (User u2 : qr.getObjects()) {
                    if (u.getUserId() == null) {
                        return new ValidatorResult(false, "gebruikersnaam reeds in gebruik (1)");
                    }
                    if (u.getUserId() == u2.getUserId()) continue;
                    return new ValidatorResult(false, "gebruikersnaam reeds in gebruik (2)");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            u.setUsername(n);
            return null;
        });
        super.addValidator("email", u -> {
            String e = u.getEmail();
            if (e == null) {
                return null;
            }
            if ((e = e.trim()).length() == 0) {
                return null;
            }
            if (!e.matches("^[^@ ]+@[^@ ]+\\.[^@ ]+$")) {
                return new ValidatorResult(false, "ongeldig adres");
            }
            u.setEmail(e);
            return null;
        });
        super.addValidator("password", u -> {
            if (u.getUserId() != null) {
                return null;
            }
            if (u.getPassword() == null || u.getPassword().trim().length() == 0) {
                return new ValidatorResult(false, "required");
            }
            return null;
        });
    }
}

