/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.Note;
import itx.erp.base.service.NoteService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class NoteController
extends BaseController {
    protected NoteService noteService;

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Note note;
        Integer noteId = req.getParamInt("noteId");
        if (noteId != null) {
            note = this.noteService.readNote(noteId);
        } else {
            note = new Note();
            note.setRefObject(req.getParameter("refObject"));
            note.setRefId(req.getParamInt("refId"));
        }
        note.setShortNote(req.getParameter("shortNote"));
        note.setLongNote(req.getParameter("longNote"));
        note.setImportant(req.getParamBool("important"));
        noteId = this.noteService.save(note, req.getUserId());
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("noteId", noteId);
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        String strIds = req.getParameter("noteIds");
        List<Integer> ids = NumberUtil.csl2int(strIds);
        this.noteService.updateNoteSort(ids);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer noteId = req.getParamInt("noteId");
        Note note = this.noteService.readNote(noteId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("note", note);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer noteId = req.getParamInt("noteId");
        this.noteService.deleteNote(noteId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void searchAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        String refObject = req.getParameter("refObject");
        Integer refId = req.getParamInt("refId");
        List<Note> notes = this.noteService.readByRef(refObject, refId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("notes", notes);
        req.renderJson(result);
    }
}

