/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.validator.UserGroupValidator;
import itx.erp.base.service.GroupService;
import itx.erp.base.service.UserService;
import itx.erp.exception.ObjectNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.ContainerException;
import jtbcore.model.mapper.KeyValueListMapper;
import jtbcore.util.NumberUtil;

public class GroupsController
extends BaseController {
    protected GroupService groupService;
    protected UserService userService;

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        if (!this.userService.isAdmin(webRequest.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest r) throws StreamWriteException, DatabindException, IOException, SQLException {
        QueryResult<UserGroup> qr = this.groupService.searchGroups(null);
        r.renderJson(qr);
    }

    public void viewAction(WebRequest req) throws Exception {
        Integer groupId = req.getParamInt("groupId", null);
        UserGroup ug = this.groupService.readGroup(groupId);
        if (ug == null) {
            throw new ObjectNotFoundException("Group not found");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userGroup", ug);
        List<User> users = this.userService.readByGroup(ug.getUserGroupId());
        ArrayList recusers = new ArrayList();
        int x = 0;
        while (x < users.size()) {
            User u = users.get(x);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userId", u.getUserId());
            m.put("username", u.getUsername());
            m.put("userType", u.getUserType());
            m.put("email", u.getEmail());
            m.put("firstname", u.getFirstname());
            m.put("lastname", u.getLastname());
            recusers.add(m);
            ++x;
        }
        result.put("users", recusers);
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest r) throws SQLException {
        String ids = r.getParameter("ids");
        if (ids == null) {
            return;
        }
        String[] arrIds = ids.split(",");
        int x = 0;
        while (x < arrIds.length) {
            Integer id = NumberUtil.tryParseInt(arrIds[x]);
            if (id != null) {
                this.groupService.updateSort(id, x);
            }
            ++x;
        }
    }

    public void saveAction(WebRequest r) throws SQLException, ContainerException, IllegalAccessException, InvocationTargetException, IOException {
        Integer userGroupId = r.getParamInt("user_group_id");
        UserGroup ug = new UserGroup();
        if (userGroupId != null) {
            ug = this.groupService.readGroup(userGroupId);
        }
        UserGroupValidator v = new UserGroupValidator();
        KeyValueListMapper m = new KeyValueListMapper(r.getKvl(), v, ug);
        m.map();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (v.validate(ug)) {
            this.groupService.saveGroup(ug, r.getUserId());
            result.put("success", true);
            result.put("group", ug);
        } else {
            result.put("errors", v.getErrors());
            result.put("error", true);
        }
        r.renderJson(result);
    }

    public void deleteGroupAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        Integer userGroupId = req.getParamInt("userGroupId");
        this.groupService.deleteGroup(userGroupId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

