/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.model.UserPermissionList;
import itx.erp.base.service.FileService;
import itx.erp.base.service.UserPermissionService;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Part;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.FileUtil;
import jtbcore.util.ImageUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.ProcUtil;

public class FilesController
extends BaseController {
    protected ErpConfig appConfig;
    protected FileService fileService;
    protected UserService userService;
    protected UserPermissionService userPermissionService;

    public ErpObjectContainer getObjectContainer() {
        return ErpObjectContainer.getInstance();
    }

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserPermissionService getUserPermissionService() {
        return this.userPermissionService;
    }

    public void setUserPermissionService(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws Exception {
        this.searchAction(req);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        User user = this.userService.readUser(req.getUserId());
        Integer start = req.getParamInt("pageNo", 0) * this.appConfig.getLimit();
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        opts.put("customerId", req.getParamInt("customerId"));
        String strSelectedFileIds = req.getParameter("selectedFileIds");
        List<Integer> selectedFileIds = NumberUtil.csl2int(strSelectedFileIds);
        opts.put("selectedFileIds", selectedFileIds);
        QueryResult<DbFile> files = this.fileService.searchFiles(user, opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("start", files.getStart());
        result.put("pageSize", files.getPageSize());
        result.put("rowCount", files.getRowCount());
        result.put("files", files.getObjects());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws Exception {
        User user = this.userService.readUser(req.getUserId());
        Integer i = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(i);
        this.userPermissionService.checkAccess(user, "file", f.getDbFileId());
        UserPermissionList upl = this.userPermissionService.getPermissions(user, "file", f.getDbFileId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("file", f);
        result.put("accessMethod", upl.getAccessMethod());
        result.put("userPermissionList", upl);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws Exception {
        User user = this.userService.readUser(req.getUserId());
        Integer i = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(i);
        this.userPermissionService.checkAccess(user, "file", f.getDbFileId());
        this.fileService.deleteFile(f, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("file", f);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws IOException, ServletException, SQLException, JTBException {
        User user = this.userService.readUser(req.getUserId());
        Part p = req.getRequest().getPart("file");
        String filename = FileUtil.normalizedBasename(p.getSubmittedFileName());
        DbFile f = new DbFile();
        f.setOriginalFilename(filename);
        f.setRefDescription(req.getParameter("ref_description"));
        f.setNote(req.getParameter("note"));
        this.fileService.saveFile(user, f, true);
        String path = String.valueOf(f.getDbFileId()) + "-" + f.getOriginalFilename();
        f.setPath(path);
        String file = this.getObjectContainer().getFilesDir() + "/" + path;
        InputStream is = p.getInputStream();
        Integer s = FileUtil.inputStream2File(is, file);
        f.setSize(s);
        is.close();
        this.fileService.saveFile(user, f, false);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("file", f);
        req.renderJson(result);
    }

    public void saveSettingsAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        User user = this.userService.readUser(req.getUserId());
        Integer id = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(id);
        f.setRefDescription(req.getParameter("refDescription"));
        f.setNote(req.getParameter("note"));
        this.fileService.saveFile(null, f, true);
        List<KeyValueList> kvlPermissions = req.getKvl().getList("permissions");
        this.userPermissionService.saveKvlPermissions("file", f.getDbFileId(), kvlPermissions);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void openFileAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        if (!this.appConfig.isDesktopMode()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", true);
            result.put("messag", "Not in desktop mode");
            req.renderJson(result);
            return;
        }
        Integer id = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(id);
        String p = this.getObjectContainer().getFilesDir() + "/" + f.getPath();
        ProcUtil.openUrlInBrowser(p);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void downloadFileAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        User user = this.userService.readUser(req.getUserId());
        Integer id = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(id);
        this.userPermissionService.checkAccess(user, "file", f.getDbFileId());
        String p = this.getObjectContainer().getFilesDir() + "/" + f.getPath();
        File file = new File(p);
        String attinline = req.getParamBool("inline") != false ? "inline" : "attachment";
        req.getResponse().setHeader("Content-Disposition", attinline + "; filename=\"" + f.getOriginalFilename() + "\"");
        FileUtil.file2outputstream(file, (OutputStream)req.getResponse().getOutputStream());
    }

    public void sampleAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("id");
        DbFile f = null;
        if (id != null) {
            f = this.fileService.readFile(id);
        }
        if (f == null) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("error", true);
            r.put("message", "File not found");
            req.renderJson(r);
            return;
        }
        ServletOutputStream os = req.getResponse().getOutputStream();
        String ext = FileUtil.extension(f.getOriginalFilename());
        if ("jpg".equals(ext) || "jpeg".equals(ext) || "png".equals(ext) || "gif".equals(ext)) {
            BufferedImage img = ImageIO.read(new File(f.getSystemPath()));
            BufferedImage img2 = ImageUtil.resize(img, 100, 100);
            req.getResponse().setContentType("image/jpg");
            ImageUtil.writeAsJpegToOutputStream(img2, 0.7f, (OutputStream)os);
            return;
        }
        req.getResponse().setContentType("image/png");
        Throwable throwable = null;
        Object var7_11 = null;
        try (InputStream is = ErpConfig.getResourceAsInput("/itx/erp/resources/file-100x100.png");){
            FileUtil.copy(is, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

